/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Axis {
    final ObjectNode spec;

    Axis(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Axis title(String title) {
        this.spec.put("title", title);
        return this;
    }

    public Axis aria(boolean flag) {
        this.spec.put("aria", flag);
        return this;
    }

    public Axis bandPosition(double position) {
        this.spec.put("bandPosition", position);
        return this;
    }

    public Axis description(String description) {
        this.spec.put("description", description);
        return this;
    }

    public Axis maxExtent(int extent) {
        this.spec.put("maxExtent", extent);
        return this;
    }

    public Axis minExtent(int extent) {
        this.spec.put("minExtent", extent);
        return this;
    }

    public Axis orient(String orient) {
        this.spec.put("orient", orient);
        return this;
    }

    public Axis offset(double offset) {
        this.spec.put("offset", offset);
        return this;
    }

    public Axis position(double position) {
        this.spec.put("position", position);
        return this;
    }

    public Axis translate(double translate) {
        this.spec.put("translate", translate);
        return this;
    }

    public Axis zindex(int zindex) {
        this.spec.put("zindex", zindex);
        return this;
    }

    public Axis style(String ... style) {
        if (style.length == 1) {
            this.spec.put("style", style[0]);
        } else {
            ArrayNode node = this.spec.putArray("style");
            for (String s : style) {
                node.add(s);
            }
        }
        return this;
    }

    public Axis domain(boolean flag) {
        this.spec.put("domain", flag);
        return this;
    }

    public Axis domainCap(String cap) {
        this.spec.put("domainCap", cap);
        return this;
    }

    public Axis domainColor(String color) {
        this.spec.put("domainColor", color);
        return this;
    }

    public Axis domainOpacity(double opacity) {
        this.spec.put("domainOpacity", opacity);
        return this;
    }

    public Axis domainWidth(double width) {
        this.spec.put("domainWidth", width);
        return this;
    }

    public Axis domainDash(double stroke, double space) {
        this.spec.putArray("domainDash").add(stroke).add(space);
        return this;
    }

    public Axis domainDashOffset(double offset) {
        this.spec.put("domainDashOffset", offset);
        return this;
    }

    public Axis format(String format) {
        this.spec.put("format", format);
        return this;
    }

    public Axis formatType(String formatType) {
        this.spec.put("formatType", formatType);
        return this;
    }

    public Axis labels(boolean flag) {
        this.spec.put("labels", flag);
        return this;
    }

    public Axis labelAlign(String strategy) {
        this.spec.put("labelAlign", strategy);
        return this;
    }

    public Axis labelAngle(double angle) {
        this.spec.put("labelAngle", angle);
        return this;
    }

    public Axis labelBaseline(String baseline) {
        this.spec.put("labelBaseline", baseline);
        return this;
    }

    public Axis labelBound(boolean flag) {
        this.spec.put("labelBound", flag);
        return this;
    }

    public Axis labelBound(double tolerance) {
        this.spec.put("labelBound", tolerance);
        return this;
    }

    public Axis labelColor(String color) {
        this.spec.put("labelColor", color);
        return this;
    }

    public Axis labelExpr(String expr) {
        this.spec.put("labelExpr", expr);
        return this;
    }

    public Axis labelFlush(boolean flag) {
        this.spec.put("labelFlush", flag);
        return this;
    }

    public Axis labelFlush(double adjustment) {
        this.spec.put("labelFlush", adjustment);
        return this;
    }

    public Axis labelFlushOffset(double offset) {
        this.spec.put("labelFlushOffset", offset);
        return this;
    }

    public Axis labelFont(String font) {
        this.spec.put("labelFont", font);
        return this;
    }

    public Axis labelFontSize(double size) {
        this.spec.put("labelFontSize", size);
        return this;
    }

    public Axis labelFontStyle(String style) {
        this.spec.put("labelFontStyle", style);
        return this;
    }

    public Axis labelFontWeight(String weight) {
        this.spec.put("labelFontWeight", weight);
        return this;
    }

    public Axis labelFontWeight(int weight) {
        this.spec.put("labelFontWeight", weight);
        return this;
    }

    public Axis labelLimit(int limit) {
        this.spec.put("labelLimit", limit);
        return this;
    }

    public Axis labelLineHeight(int height) {
        this.spec.put("labelLineHeight", height);
        return this;
    }

    public Axis labelLineHeight(String height) {
        this.spec.put("labelLineHeight", height);
        return this;
    }

    public Axis labelOffset(int offset) {
        this.spec.put("labelOffset", offset);
        return this;
    }

    public Axis labelOpacity(double opacity) {
        this.spec.put("labelOpacity", opacity);
        return this;
    }

    public Axis labelOverlap(boolean flag) {
        this.spec.put("labelOverlap", flag);
        return this;
    }

    public Axis labelOverlap(String strategy) {
        this.spec.put("labelOverlap", strategy);
        return this;
    }

    public Axis labelPadding(double padding) {
        this.spec.put("labelPadding", padding);
        return this;
    }

    public Axis labelSeparation(double separation) {
        this.spec.put("labelSeparation", separation);
        return this;
    }

    public Axis grid(boolean flag) {
        this.spec.put("grid", flag);
        return this;
    }

    public Axis gridCap(String cap) {
        this.spec.put("gridCap", cap);
        return this;
    }

    public Axis gridColor(String color) {
        this.spec.put("gridColor", color);
        return this;
    }

    public Axis gridOpacity(double opacity) {
        this.spec.put("gridOpacity", opacity);
        return this;
    }

    public Axis gridWidth(double width) {
        this.spec.put("gridWidth", width);
        return this;
    }

    public Axis gridDash(double stroke, double space) {
        this.spec.putArray("gridDash").add(stroke).add(space);
        return this;
    }

    public Axis ticks(boolean flag) {
        this.spec.put("ticks", flag);
        return this;
    }

    public Axis tickBand(String band) {
        this.spec.put("tickBand", band);
        return this;
    }

    public Axis tickCap(String cap) {
        this.spec.put("tickCap", cap);
        return this;
    }

    public Axis tickColor(String color) {
        this.spec.put("tickColor", color);
        return this;
    }

    public Axis tickCount(int count) {
        this.spec.put("tickCount", count);
        return this;
    }
}

