/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.VegaLite;

public class BinParams {
    final ObjectNode spec = VegaLite.mapper.createObjectNode();

    public BinParams anchor(double value) {
        this.spec.put("anchor", value);
        return this;
    }

    public BinParams base(int base) {
        this.spec.put("base", base);
        return this;
    }

    public BinParams divide(int ... factors) {
        ArrayNode node = this.spec.putArray("divide");
        for (int factor : factors) {
            node.add(factor);
        }
        return this;
    }

    public BinParams extent(double min, double max) {
        this.spec.putArray("extent").add(min).add(max);
        return this;
    }

    public BinParams maxBins(int bins) {
        this.spec.put("maxbins", bins);
        return this;
    }

    public BinParams minStep(double size) {
        this.spec.put("minstep", size);
        return this;
    }

    public BinParams step(double size) {
        this.spec.put("step", size);
        return this;
    }

    public BinParams steps(double ... steps) {
        ArrayNode node = this.spec.putArray("steps");
        for (double step : steps) {
            node.add(step);
        }
        return this;
    }

    public BinParams nice(int flag) {
        this.spec.put("nice", flag);
        return this;
    }
}

