/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class ImputeTransform {
    final ObjectNode spec;

    ImputeTransform(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public ImputeTransform keyvals(double[] values) {
        ArrayNode node = this.spec.putArray("keyvals");
        for (double value : values) {
            node.add(value);
        }
        return this;
    }

    public ImputeTransform keyvals(double start, double stop, double step) {
        ObjectNode node = this.spec.putObject("keyvals");
        node.put("start", start).put("stop", stop).put("step", step);
        return this;
    }

    public ImputeTransform groupby(String ... fields) {
        ArrayNode node = this.spec.putArray("groupby");
        for (String field : fields) {
            node.add(field);
        }
        return this;
    }

    public ImputeTransform frame(Integer first, Integer last) {
        this.spec.putArray("frame").add(first == null ? null : Integer.valueOf(first)).add(last == null ? null : Integer.valueOf(last));
        return this;
    }

    public ImputeTransform method(String method) {
        this.spec.put("method", method);
        return this;
    }

    public ImputeTransform value(JsonNode value) {
        this.spec.set("value", value);
        return this;
    }
}

