/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Legend {
    final ObjectNode spec;

    Legend(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Legend title(String title) {
        this.spec.put("title", title);
        return this;
    }

    public Legend aria(boolean flag) {
        this.spec.put("aria", flag);
        return this;
    }

    public Legend cornerRadius(double radius) {
        this.spec.put("cornerRadius", radius);
        return this;
    }

    public Legend description(String description) {
        this.spec.put("description", description);
        return this;
    }

    public Legend direction(String direction) {
        this.spec.put("direction", direction);
        return this;
    }

    public Legend fillColor(String color) {
        this.spec.put("fillColor", color);
        return this;
    }

    public Legend x(double x) {
        this.spec.put("legendX", x);
        return this;
    }

    public Legend y(double y) {
        this.spec.put("legendY", y);
        return this;
    }

    public Legend offset(double offset) {
        this.spec.put("offset", offset);
        return this;
    }

    public Legend orient(String orient) {
        this.spec.put("orient", orient);
        return this;
    }

    public Legend padding(double padding) {
        this.spec.put("padding", padding);
        return this;
    }

    public Legend strokeColor(String color) {
        this.spec.put("strokeColor", color);
        return this;
    }

    public Legend type(String type) {
        this.spec.put("type", type);
        return this;
    }

    public Legend tickCount(int count) {
        this.spec.put("tickCount", count);
        return this;
    }

    public Legend tickCount(String expr) {
        this.spec.put("tickCount", expr);
        return this;
    }

    public Legend values(String ... values) {
        ArrayNode node = this.spec.putArray("values");
        for (String value : values) {
            node.add(value);
        }
        return this;
    }

    public Legend zindex(int zindex) {
        this.spec.put("zindex", zindex);
        return this;
    }

    public Legend gradientLength(double length) {
        this.spec.put("gradientLength", length);
        return this;
    }

    public Legend gradientOpacity(double opacity) {
        this.spec.put("gradientOpacity", opacity);
        return this;
    }

    public Legend gradientStrokeColor(String color) {
        this.spec.put("gradientStrokeColor", color);
        return this;
    }

    public Legend gradientStrokeWidth(double width) {
        this.spec.put("gradientStrokeWidth", width);
        return this;
    }

    public Legend gradientThickness(double thickness) {
        this.spec.put("gradientThickness", thickness);
        return this;
    }

    public Legend format(String format) {
        this.spec.put("format", format);
        return this;
    }

    public Legend formatType(String formatType) {
        this.spec.put("formatType", formatType);
        return this;
    }

    public Legend labelAlign(String alignment) {
        this.spec.put("labelAlign", alignment);
        return this;
    }

    public Legend labelBaseline(String baseline) {
        this.spec.put("labelBaseline", baseline);
        return this;
    }

    public Legend labelColor(String color) {
        this.spec.put("labelColor", color);
        return this;
    }

    public Legend labelExpr(String expr) {
        this.spec.put("labelExpr", expr);
        return this;
    }

    public Legend labelFont(String font) {
        this.spec.put("labelFont", font);
        return this;
    }

    public Legend labelFontSize(double size) {
        this.spec.put("labelFontSize", size);
        return this;
    }

    public Legend labelFontStyle(String style) {
        this.spec.put("labelFontStyle", style);
        return this;
    }

    public Legend labelFontWeight(String weight) {
        this.spec.put("labelFontWeight", weight);
        return this;
    }

    public Legend labelFontWeight(int weight) {
        this.spec.put("labelFontWeight", weight);
        return this;
    }

    public Legend labelLimit(int limit) {
        this.spec.put("labelLimit", limit);
        return this;
    }

    public Legend labelOffset(int offset) {
        this.spec.put("labelOffset", offset);
        return this;
    }

    public Legend labelOverlap(boolean flag) {
        this.spec.put("labelOverlap", flag);
        return this;
    }

    public Legend labelOverlap(String strategy) {
        this.spec.put("labelOverlap", strategy);
        return this;
    }

    public Legend clipHeight(double height) {
        this.spec.put("clipHeight", height);
        return this;
    }

    public Legend columnPadding(double padding) {
        this.spec.put("columnPadding", padding);
        return this;
    }

    public Legend rowPadding(double padding) {
        this.spec.put("rowPadding", padding);
        return this;
    }

    public Legend columns(int columns) {
        this.spec.put("columns", columns);
        return this;
    }

    public Legend gridAlign(String alignment) {
        this.spec.put("gridAlign", alignment);
        return this;
    }

    public Legend symbolLimit(int limit) {
        this.spec.put("symbolLimit", limit);
        return this;
    }
}

