/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Mark {
    final ObjectNode spec;

    Mark(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Mark aria(boolean aria) {
        this.spec.put("aria", aria);
        return this;
    }

    public Mark description(String description) {
        this.spec.put("description", description);
        return this;
    }

    public Mark style(String ... style) {
        if (style.length == 1) {
            this.spec.put("style", style[0]);
        } else {
            ArrayNode node = this.spec.putArray("style");
            for (String s : style) {
                node.add(s);
            }
        }
        return this;
    }

    public Mark tooltip(String tooltip) {
        if (tooltip.equals("encoding") || tooltip.equals("data")) {
            ObjectNode node = this.spec.putObject("tooltip");
            node.put("content", tooltip);
        } else {
            this.spec.put("tooltip", tooltip);
        }
        return this;
    }

    public Mark tooltip(boolean flag) {
        this.spec.put("tooltip", flag);
        return this;
    }

    public Mark clip(boolean flag) {
        this.spec.put("clip", flag);
        return this;
    }

    public Mark invalid(String invalid) {
        this.spec.put("invalid", invalid);
        return this;
    }

    public Mark order(boolean flag) {
        this.spec.put("order", flag);
        return this;
    }

    public Mark x(double value) {
        this.spec.put("x", value);
        return this;
    }

    public Mark x(String width) {
        assert (width == "width") : "Invalid width: " + width;
        this.spec.put("x", width);
        return this;
    }

    public Mark x2(double value) {
        this.spec.put("x2", value);
        return this;
    }

    public Mark x2(String width) {
        assert (width == "width") : "Invalid width: " + width;
        this.spec.put("x2", width);
        return this;
    }

    public Mark y(double value) {
        this.spec.put("y", value);
        return this;
    }

    public Mark y(String height) {
        assert (height == "height") : "Invalid height: " + height;
        this.spec.put("y", height);
        return this;
    }

    public Mark y2(double value) {
        this.spec.put("y2", value);
        return this;
    }

    public Mark y2(String height) {
        assert (height == "height") : "Invalid height: " + height;
        this.spec.put("y2", height);
        return this;
    }

    public Mark xOffset(double offset) {
        this.spec.put("xOffset", offset);
        return this;
    }

    public Mark x2Offset(double offset) {
        this.spec.put("x2Offset", offset);
        return this;
    }

    public Mark yOffset(double offset) {
        this.spec.put("yOffset", offset);
        return this;
    }

    public Mark y2Offset(double offset) {
        this.spec.put("y2Offset", offset);
        return this;
    }

    public Mark width(double width) {
        this.spec.put("width", width);
        return this;
    }

    public Mark height(double height) {
        this.spec.put("height", height);
        return this;
    }

    public Mark filled(boolean flag) {
        this.spec.put("filled", flag);
        return this;
    }

    public Mark color(String color) {
        this.spec.put("color", color);
        return this;
    }

    public Mark fill(String color) {
        this.spec.put("fill", color);
        return this;
    }

    public Mark stroke(String color) {
        this.spec.put("stroke", color);
        return this;
    }

    public Mark blend(String mode) {
        this.spec.put("blend", mode);
        return this;
    }

    public Mark opacity(double opacity) {
        this.spec.put("opacity", opacity);
        return this;
    }

    public Mark fillOpacity(double opacity) {
        this.spec.put("fillOpacity", opacity);
        return this;
    }

    public Mark strokeOpacity(double opacity) {
        this.spec.put("strokeOpacity", opacity);
        return this;
    }

    public Mark strokeCap(String cap) {
        this.spec.put("strokeCap", cap);
        return this;
    }

    public Mark strokeDash(double stroke, double space) {
        this.spec.putArray("strokeDash").add(stroke).add(space);
        return this;
    }

    public Mark strokeDashOffset(double offset) {
        this.spec.put("strokeDashOffset", offset);
        return this;
    }

    public Mark strokeJoin(String join) {
        this.spec.put("strokeJoin", join);
        return this;
    }

    public Mark strokeMiterLimit(double limit) {
        this.spec.put("strokeMiterLimit", limit);
        return this;
    }

    public Mark strokeWidth(double width) {
        this.spec.put("strokeWidth", width);
        return this;
    }

    public Mark point(boolean flag) {
        this.spec.put("point", flag);
        return this;
    }

    public Mark shape(String shape) {
        this.spec.put("shape", shape);
        return this;
    }

    public Mark size(int size) {
        this.spec.put("size", size);
        return this;
    }

    public Mark extent(String extent) {
        this.spec.put("extent", extent);
        return this;
    }

    public Mark line(boolean flag) {
        this.spec.put("line", flag);
        return this;
    }

    public Mark orient(String orient) {
        this.spec.put("orient", orient);
        return this;
    }

    public Mark interpolate(String method) {
        this.spec.put("interpolate", method);
        return this;
    }

    public Mark tension(double value) {
        this.spec.put("tension", value);
        return this;
    }

    public Mark radius(double radius) {
        this.spec.put("radius", radius);
        return this;
    }

    public Mark radius2(double radius) {
        this.spec.put("radius2", radius);
        return this;
    }

    public Mark outerRadius(double radius) {
        this.spec.put("outerRadius", radius);
        return this;
    }

    public Mark innerRadius(double radius) {
        this.spec.put("innerRadius", radius);
        return this;
    }

    public Mark radiusOffset(double offset) {
        this.spec.put("radiusOffset", offset);
        return this;
    }

    public Mark radius2Offset(double offset) {
        this.spec.put("radius2Offset", offset);
        return this;
    }

    public Mark theta(double angle) {
        this.spec.put("theta", angle);
        return this;
    }

    public Mark theta2(double angle) {
        this.spec.put("theta2", angle);
        return this;
    }

    public Mark thetaOffset(double offset) {
        this.spec.put("thetaOffset", offset);
        return this;
    }

    public Mark theta2Offset(double offset) {
        this.spec.put("theta2Offset", offset);
        return this;
    }

    public Mark padAngle(double angle) {
        this.spec.put("padAngle", angle);
        return this;
    }

    public Mark cornerRadius(double radius) {
        this.spec.put("cornerRadius", radius);
        return this;
    }

    public Mark cornerRadiusEnd(double radius) {
        this.spec.put("cornerRadiusEnd", radius);
        return this;
    }

    public Mark cornerRadiusTopLeft(double radius) {
        this.spec.put("cornerRadiusTopLeft", radius);
        return this;
    }

    public Mark cornerRadiusTopRight(double radius) {
        this.spec.put("cornerRadiusTopRight", radius);
        return this;
    }

    public Mark cornerRadiusBottomLeft(double radius) {
        this.spec.put("cornerRadiusBottomLeft", radius);
        return this;
    }

    public Mark cornerRadiusBottomRight(double radius) {
        this.spec.put("cornerRadiusBottomRight", radius);
        return this;
    }
}

