/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.VegaLite;

public class Predicate {
    final ObjectNode spec;
    final String expr;

    public Predicate(String expr) {
        this.spec = null;
        this.expr = expr;
    }

    public Predicate(String param, boolean empty) {
        this.expr = null;
        this.spec = VegaLite.mapper.createObjectNode();
        this.spec.put("param", param).put("empty", empty);
    }

    Predicate(ObjectNode spec) {
        this.spec = spec;
        this.expr = null;
    }

    public Predicate timeUnit(String timeUnit) {
        assert (this.spec != null && this.spec.has("field")) : "Not a Field Predicate";
        this.spec.put("timeUnit", timeUnit);
        return this;
    }

    public static Predicate of(String field, String op, boolean value) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field).put(op, value);
        return new Predicate(node);
    }

    public static Predicate of(String field, String op, double value) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field).put(op, value);
        return new Predicate(node);
    }

    public static Predicate of(String field, String op, String value) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field).put(op, value);
        return new Predicate(node);
    }

    public static Predicate range(String field, double min, double max) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field);
        node.putArray("range").add(min).add(max);
        return new Predicate(node);
    }

    public static Predicate oneOf(String field, double ... values) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field);
        ArrayNode array = node.putArray("oneOf");
        for (double value : values) {
            array.add(value);
        }
        return new Predicate(node);
    }

    public static Predicate oneOf(String field, String ... values) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field);
        ArrayNode array = node.putArray("oneOf");
        for (String value : values) {
            array.add(value);
        }
        return new Predicate(node);
    }

    public static Predicate valid(String field) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        node.put("field", field).put("valid", true);
        return new Predicate(node);
    }

    public static Predicate and(Predicate ... predicates) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        ArrayNode array = node.putArray("and");
        for (Predicate predicate : predicates) {
            if (predicate.expr != null) {
                array.add(predicate.expr);
                continue;
            }
            array.add((JsonNode)predicate.spec);
        }
        return new Predicate(node);
    }

    public static Predicate or(Predicate ... predicates) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        ArrayNode array = node.putArray("or");
        for (Predicate predicate : predicates) {
            if (predicate.expr != null) {
                array.add(predicate.expr);
                continue;
            }
            array.add((JsonNode)predicate.spec);
        }
        return new Predicate(node);
    }

    public static Predicate not(Predicate predicate) {
        ObjectNode node = VegaLite.mapper.createObjectNode();
        if (predicate.expr != null) {
            node.put("not", predicate.expr);
        } else {
            node.set("not", (JsonNode)predicate.spec);
        }
        return new Predicate(node);
    }
}

