/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Projection {
    final ObjectNode spec;

    Projection(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Projection center(double longitude, double latitude) {
        ArrayNode node = this.spec.putArray("center");
        node.add(longitude);
        node.add(latitude);
        return this;
    }

    public Projection clipAngle(double angle) {
        this.spec.put("clipAngle", angle);
        return this;
    }

    public Projection clipExtent(double x0, double y0, double x1, double y1) {
        ArrayNode extend = this.spec.putArray("clipExtent");
        extend.addArray().add(x0).add(y0);
        extend.addArray().add(x1).add(y1);
        return this;
    }

    public Projection parallels(double ... parallels) {
        ArrayNode node = this.spec.putArray("parallels");
        for (double parallel : parallels) {
            node.add(parallel);
        }
        return this;
    }

    public Projection pointRadius(double radius) {
        this.spec.put("pointRadius", radius);
        return this;
    }

    public Projection precision(double threshold) {
        this.spec.put("precision", threshold);
        return this;
    }

    public Projection rotate(double lambda, double phi, double gamma) {
        ArrayNode node = this.spec.putArray("rotate");
        node.add(lambda);
        node.add(phi);
        node.add(gamma);
        return this;
    }

    public Projection scale(double scale) {
        this.spec.put("scale", scale);
        return this;
    }

    public Projection translate(double tx, double ty) {
        ArrayNode node = this.spec.putArray("translate");
        node.add(tx);
        node.add(ty);
        return this;
    }
}

