/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.Background;
import smile.plot.vega.Field;
import smile.plot.vega.Mark;
import smile.plot.vega.Projection;
import smile.plot.vega.VegaLite;

public class View
extends VegaLite {
    public View() {
    }

    public View(String title) {
        this.title(title);
    }

    public View width(int width) {
        this.spec.put("width", width);
        return this;
    }

    public View height(int height) {
        this.spec.put("height", height);
        return this;
    }

    public View width(String width) {
        assert (width == "container") : "Invalid width: " + width;
        this.spec.put("width", width);
        return this;
    }

    public View height(String height) {
        assert (height == "container") : "Invalid height: " + height;
        this.spec.put("height", height);
        return this;
    }

    public View widthStep(int step) {
        ObjectNode width = this.spec.putObject("width");
        width.put("step", step);
        return this;
    }

    public View heightStep(int step) {
        ObjectNode height = this.spec.putObject("height");
        height.put("step", step);
        return this;
    }

    public Mark mark(String type) {
        ObjectNode node = this.spec.putObject("mark");
        node.put("type", type);
        return new Mark(node);
    }

    public Background background() {
        return new Background(this.spec.has("view") ? (ObjectNode)this.spec.get("view") : this.spec.putObject("view"));
    }

    public Projection projection(String type) {
        ObjectNode node = this.spec.putObject("projection");
        node.put("type", type);
        return new Projection(node);
    }

    public Field encode(String channel, String field) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        if (field == null) {
            node.putNull("field");
        } else if (field.startsWith("repeat:")) {
            node.putObject("field").put("repeat", field.substring(7));
        } else {
            node.put("field", field);
        }
        return new Field(node);
    }

    public View encodeValue(String channel, int value) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("value", value);
        return this;
    }

    public View encodeValue(String channel, double value) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("value", value);
        return this;
    }

    public View encodeValue(String channel, String value) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("value", value);
        return this;
    }

    public View encodeDatum(String channel, int datum) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("datum", datum);
        return this;
    }

    public View encodeDatum(String channel, double datum) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("datum", datum);
        return this;
    }

    public View encodeDatum(String channel, String datum) {
        ObjectNode encoding = this.encoding();
        ObjectNode node = encoding.putObject(channel);
        node.put("datum", datum);
        return this;
    }

    @Override
    public View usermeta(JsonNode metadata) {
        super.usermeta(metadata);
        return this;
    }

    @Override
    public View usermeta(Object metadata) {
        super.usermeta(metadata);
        return this;
    }

    @Override
    public View background(String color) {
        super.background(color);
        return this;
    }

    @Override
    public View padding(int size) {
        super.padding(size);
        return this;
    }

    @Override
    public View padding(int left, int top, int right, int bottom) {
        super.padding(left, top, right, bottom);
        return this;
    }

    @Override
    public View autosize() {
        super.autosize();
        return this;
    }

    @Override
    public View autosize(String type, boolean resize, String contains) {
        super.autosize(type, resize, contains);
        return this;
    }

    @Override
    public View name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public View description(String description) {
        super.description(description);
        return this;
    }

    @Override
    public View title(String title) {
        super.title(title);
        return this;
    }
}

