/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.Axis;

public class ViewConfig {
    final ObjectNode spec;

    ViewConfig(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public ViewConfig continuousWidth(int width) {
        this.spec.put("continuousWidth", width);
        return this;
    }

    public ViewConfig continuousHeight(int height) {
        this.spec.put("continuousHeight", height);
        return this;
    }

    public ViewConfig discreteWidth(int width) {
        this.spec.put("discreteWidth", width);
        return this;
    }

    public ViewConfig discreteHeight(int height) {
        this.spec.put("discreteHeight", height);
        return this;
    }

    public ViewConfig step(int step) {
        this.spec.put("step", step);
        return this;
    }

    public ViewConfig cornerRadius(int cornerRadius) {
        this.spec.put("cornerRadius", cornerRadius);
        return this;
    }

    public ViewConfig cursor(String cursor) {
        this.spec.put("cursor", cursor);
        return this;
    }

    public ViewConfig fill(String color) {
        this.spec.put("fill", color);
        return this;
    }

    public ViewConfig fillOpacity(double opacity) {
        this.spec.put("fillOpacity", opacity);
        return this;
    }

    public ViewConfig opacity(double opacity) {
        this.spec.put("opacity", opacity);
        return this;
    }

    public ViewConfig stroke(String color) {
        this.spec.put("stroke", color);
        return this;
    }

    public ViewConfig strokeCap(String cap) {
        this.spec.put("strokeCap", cap);
        return this;
    }

    public ViewConfig strokeDash(double stroke, double space) {
        this.spec.putArray("strokeDash").add(stroke).add(space);
        return this;
    }

    public ViewConfig strokeDashOffset(int offset) {
        this.spec.put("strokeDashOffset", offset);
        return this;
    }

    public ViewConfig strokeJoin(String join) {
        this.spec.put("strokeJoin", join);
        return this;
    }

    public ViewConfig strokeMiterLimit(int limit) {
        this.spec.put("strokeMiterLimit", limit);
        return this;
    }

    public ViewConfig strokeOpacity(double opacity) {
        this.spec.put("strokeOpacity", opacity);
        return this;
    }

    public ViewConfig strokeWidth(int width) {
        this.spec.put("strokeWidth", width);
        return this;
    }

    public Axis axis() {
        ObjectNode node = this.spec.has("axis") ? (ObjectNode)this.spec.get("axis") : this.spec.putObject("axis");
        return new Axis(node);
    }
}

