/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.SortField;

public class WindowTransform {
    final ObjectNode spec;

    WindowTransform(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public WindowTransform frame(Integer first, Integer last) {
        this.spec.putArray("frame").add(first == null ? null : Integer.valueOf(first)).add(last == null ? null : Integer.valueOf(last));
        return this;
    }

    public WindowTransform ignorePeers(boolean flag) {
        this.spec.put("ignorePeers", flag);
        return this;
    }

    public WindowTransform groupby(String ... fields) {
        ArrayNode node = this.spec.putArray("groupby");
        for (String field : fields) {
            node.add(field);
        }
        return this;
    }

    public WindowTransform sort(String ... fields) {
        ArrayNode node = this.spec.putArray("sort");
        for (String field : fields) {
            node.addObject().put("field", field);
        }
        return this;
    }

    public WindowTransform sort(SortField ... fields) {
        ArrayNode node = this.spec.putArray("sort");
        for (SortField field : fields) {
            node.addObject().put("field", field.field()).put("order", field.order());
        }
        return this;
    }
}

