/*
 * Decompiled with CFR 0.152.
 */
package smile.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import smile.swing.table.ByteArrayCellRenderer;
import smile.swing.table.ColorCellEditor;
import smile.swing.table.ColorCellRenderer;
import smile.swing.table.DateCellEditor;
import smile.swing.table.DateCellRenderer;
import smile.swing.table.DoubleArrayCellEditor;
import smile.swing.table.DoubleArrayCellRenderer;
import smile.swing.table.DoubleCellEditor;
import smile.swing.table.FloatArrayCellRenderer;
import smile.swing.table.FontCellEditor;
import smile.swing.table.FontCellRenderer;
import smile.swing.table.IntegerArrayCellEditor;
import smile.swing.table.IntegerArrayCellRenderer;
import smile.swing.table.IntegerCellEditor;
import smile.swing.table.LongArrayCellRenderer;
import smile.swing.table.MultiColumnSortTableHeaderCellRenderer;
import smile.swing.table.PageTableModel;
import smile.swing.table.ShortArrayCellRenderer;
import smile.swing.table.TableCopyPasteAdapter;

public class Table
extends JXTable {
    private static TableCellRenderer colorRenderer = new ColorCellRenderer();
    private static TableCellRenderer fontRenderer = new FontCellRenderer();
    private static TableCellRenderer byteArrayRenderer = new ByteArrayCellRenderer();
    private static TableCellRenderer shortArrayRenderer = new ShortArrayCellRenderer();
    private static TableCellRenderer intArrayRenderer = new IntegerArrayCellRenderer();
    private static TableCellRenderer longArrayRenderer = new LongArrayCellRenderer();
    private static TableCellRenderer floatArrayRenderer = new FloatArrayCellRenderer();
    private static TableCellRenderer doubleArrayRenderer = new DoubleArrayCellRenderer();
    private static TableCellEditor colorEditor = new ColorCellEditor();
    private static TableCellEditor fontEditor = new FontCellEditor();
    private static TableCellEditor byteEditor = new IntegerCellEditor(-128, 127);
    private static TableCellEditor shortEditor = new IntegerCellEditor(Short.MIN_VALUE, Short.MAX_VALUE);
    private static TableCellEditor intEditor = new IntegerCellEditor(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private static TableCellEditor floatEditor = new DoubleCellEditor(-3.4028234663852886E38, 3.4028234663852886E38);
    private static TableCellEditor doubleEditor = new DoubleCellEditor();
    private static TableCellEditor intArrayEditor = new IntegerArrayCellEditor();
    private static TableCellEditor doubleArrayEditor = new DoubleArrayCellEditor();
    private RowHeader rowHeader;

    public Table() {
        this.init();
    }

    public Table(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public Table(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public Table(TableModel dm) {
        super(dm);
        this.init();
    }

    public Table(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public Table(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    private void init() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setColumnControlVisible(true);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping()});
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        TableCopyPasteAdapter.apply((JTable)((Object)this));
        this.getTableHeader().setDefaultRenderer(new MultiColumnSortTableHeaderCellRenderer());
        this.firePropertyChange("model", this.getModel(), this.getModel());
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        Object obj = this.getValueAt(row, column);
        if (obj == null) {
            return super.getCellRenderer(row, column);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.equals(Color.class)) {
            return colorRenderer;
        }
        if (clazz.equals(Font.class)) {
            return fontRenderer;
        }
        if (clazz.equals(Date.class)) {
            return DateCellRenderer.YYYYMMDD;
        }
        if (clazz.equals(Time.class)) {
            return DateCellRenderer.HHMMSS;
        }
        if (clazz.equals(Timestamp.class)) {
            return DateCellRenderer.ISO8601;
        }
        if (clazz.equals(byte[].class)) {
            return byteArrayRenderer;
        }
        if (clazz.equals(short[].class)) {
            return shortArrayRenderer;
        }
        if (clazz.equals(int[].class)) {
            return intArrayRenderer;
        }
        if (clazz.equals(long[].class)) {
            return longArrayRenderer;
        }
        if (clazz.equals(float[].class)) {
            return floatArrayRenderer;
        }
        if (clazz.equals(double[].class)) {
            return doubleArrayRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        Object obj = this.getValueAt(row, column);
        if (obj == null) {
            return super.getCellEditor(row, column);
        }
        Class<?> clazz = obj.getClass();
        if (clazz.equals(Color.class)) {
            return colorEditor;
        }
        if (clazz.equals(Font.class)) {
            return fontEditor;
        }
        if (clazz.equals(Date.class)) {
            return DateCellEditor.YYYYMMDD;
        }
        if (clazz.equals(Time.class)) {
            return DateCellEditor.HHMMSS;
        }
        if (clazz.equals(Timestamp.class)) {
            return DateCellEditor.ISO8601;
        }
        if (clazz.equals(java.util.Date.class)) {
            return DateCellEditor.YYYYMMDD_HHMMSS;
        }
        if (clazz.equals(Byte.TYPE)) {
            return byteEditor;
        }
        if (clazz.equals(Short.TYPE)) {
            return shortEditor;
        }
        if (clazz.equals(Integer.TYPE)) {
            return intEditor;
        }
        if (clazz.equals(Float.TYPE)) {
            return floatEditor;
        }
        if (clazz.equals(Double.TYPE)) {
            return doubleEditor;
        }
        if (clazz.equals(int[].class)) {
            return intArrayEditor;
        }
        if (clazz.equals(double[].class)) {
            return doubleArrayEditor;
        }
        return super.getCellEditor(row, column);
    }

    public JTable getRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = new RowHeader();
        }
        return this.rowHeader;
    }

    public class RowHeader
    extends JXTable
    implements ChangeListener,
    PropertyChangeListener {
        public RowHeader() {
            Table.this.addPropertyChangeListener(this);
            this.setSortable(false);
            this.setFocusable(false);
            this.setAutoCreateColumnsFromModel(false);
            this.setModel(Table.this.getModel());
            this.setSelectionModel(Table.this.getSelectionModel());
            TableColumn column = new TableColumn();
            column.setHeaderValue(" ");
            this.addColumn(column);
            column.setCellRenderer(new RowNumberRenderer());
            this.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.setPreferredScrollableViewportSize(this.getPreferredSize());
        }

        public void addNotify() {
            super.addNotify();
            Container c = this.getParent();
            if (c instanceof JViewport) {
                JViewport viewport = (JViewport)c;
                viewport.addChangeListener(this);
            }
        }

        public int getRowCount() {
            return Table.this.getRowCount();
        }

        public int getRowHeight(int row) {
            return Table.this.getRowHeight(row);
        }

        public Object getValueAt(int row, int column) {
            if (this.dataModel instanceof PageTableModel) {
                PageTableModel model = (PageTableModel)this.dataModel;
                return model.getPage() * model.getPageSize() + row + 1;
            }
            return row + 1;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            JScrollPane scrollPane = (JScrollPane)viewport.getParent();
            scrollPane.getVerticalScrollBar().setValue(viewport.getViewPosition().y);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("selectionModel".equals(e.getPropertyName())) {
                this.setSelectionModel(Table.this.getSelectionModel());
            }
            if ("model".equals(e.getPropertyName())) {
                this.setModel(Table.this.getModel());
            }
        }
    }

    private static class RowNumberRenderer
    extends DefaultTableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (isSelected) {
                this.setFont(this.getFont().deriveFont(1));
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

