/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class IntegerCellEditor
extends DefaultCellEditor {
    private static final Logger LOGGER = Logger.getLogger(IntegerCellEditor.class.getName());
    JFormattedTextField textField = (JFormattedTextField)this.getComponent();
    NumberFormat integerFormat;
    private Integer minimum;
    private Integer maximum;

    public IntegerCellEditor() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerCellEditor(int min, int max) {
        super(new JFormattedTextField());
        this.minimum = min;
        this.maximum = max;
        this.integerFormat = NumberFormat.getIntegerInstance();
        NumberFormatter intFormatter = new NumberFormatter(this.integerFormat);
        intFormatter.setFormat(this.integerFormat);
        intFormatter.setOverwriteMode(false);
        intFormatter.setMinimum(this.minimum);
        intFormatter.setMaximum(this.maximum);
        this.textField.setFormatterFactory(new DefaultFormatterFactory(intFormatter));
        this.textField.setValue(this.minimum);
        this.textField.setHorizontalAlignment(11);
        this.textField.setFocusLostBehavior(3);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.textField.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IntegerCellEditor.this.textField.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    IntegerCellEditor.this.textField.selectAll();
                } else {
                    try {
                        IntegerCellEditor.this.textField.commitEdit();
                        IntegerCellEditor.this.textField.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return this.integerFormat.parseObject(o.toString());
        }
        catch (ParseException ex) {
            LOGGER.log(Level.FINE, "getCellEditorValue: can't parse {0}", o);
            return null;
        }
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else {
            Toolkit.getDefaultToolkit().beep();
            this.textField.selectAll();
            return false;
        }
        return super.stopCellEditing();
    }
}

