/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Bar;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;

public class BarPlot
extends Plot {
    final Bar[] bars;
    final Optional<Legend[]> legends;

    public BarPlot(Bar ... bars) {
        this.bars = bars;
        this.legends = Optional.empty();
    }

    public BarPlot(Bar[] bars, Legend[] legends) {
        this.bars = bars;
        this.legends = Optional.of(legends);
    }

    @Override
    public void paint(Graphics g) {
        for (Bar bar : this.bars) {
            bar.paint(g);
        }
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = MathEx.colMin((double[][])this.bars[0].data);
        bound[0] = bound[0] - this.bars[0].width / 2.0;
        for (int k = 1; k < this.bars.length; ++k) {
            for (double[] x : this.bars[k].data) {
                if (bound[0] > x[0] - this.bars[k].width / 2.0) {
                    bound[0] = x[0] - this.bars[k].width / 2.0;
                }
                if (!(bound[1] > x[1])) continue;
                bound[1] = x[1];
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = MathEx.colMax((double[][])this.bars[0].data);
        bound[0] = bound[0] + this.bars[0].width / 2.0;
        for (int k = 1; k < this.bars.length; ++k) {
            for (double[] x : this.bars[k].data) {
                if (bound[0] < x[0] + this.bars[k].width / 2.0) {
                    bound[0] = x[0] + this.bars[k].width / 2.0;
                }
                if (!(bound[1] < x[1])) continue;
                bound[1] = x[1];
            }
        }
        return bound;
    }

    @Override
    public Optional<Legend[]> legends() {
        return this.legends;
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound());
        canvas.add(this);
        canvas.getAxis(0).setGridVisible(false);
        return canvas;
    }

    public static BarPlot of(double[] data) {
        return new BarPlot(Bar.of(data));
    }

    public static BarPlot of(int[] data) {
        return new BarPlot(Bar.of(data));
    }

    public static BarPlot of(double[][] data, String[] labels) {
        if (data.length != labels.length) {
            throw new IllegalArgumentException("The number of data groups and that of labels are not the same.");
        }
        int n = data.length;
        double width = 0.5 / (double)n;
        Bar[] bars = new Bar[n];
        Legend[] legends = new Legend[n];
        for (int i = 0; i < n; ++i) {
            double[][] x = new double[data[i].length][2];
            for (int j = 0; j < x.length; ++j) {
                x[j][0] = (double)j + (double)(i + 1) * width;
                x[j][1] = data[i][j];
            }
            Color color = Palette.COLORS[i];
            bars[i] = new Bar(x, width, color);
            legends[i] = new Legend(labels[i], color);
        }
        return new BarPlot(bars, legends);
    }
}

