/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import smile.plot.swing.Projection;
import smile.plot.swing.Projection2D;
import smile.plot.swing.Projection3D;

public class Graphics {
    final Projection projection;
    private Graphics2D g2d;
    private Shape originalClip;

    public Graphics(Projection projection) {
        this.projection = projection;
    }

    public void resetProjection() {
        this.projection.reset();
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Graphics2D getGraphics() {
        return this.g2d;
    }

    public void setGraphics(Graphics2D g2d, int width, int height) {
        this.g2d = g2d;
        this.projection.setSize(width, height);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public double[] getLowerBound() {
        return this.projection.canvas.base.lowerBound;
    }

    public double[] getUpperBound() {
        return this.projection.canvas.base.upperBound;
    }

    public Font getFont() {
        return this.g2d.getFont();
    }

    public Graphics setFont(Font font) {
        this.g2d.setFont(font);
        return this;
    }

    public Color getColor() {
        return this.g2d.getColor();
    }

    public Graphics setColor(Color color) {
        this.g2d.setColor(color);
        return this;
    }

    public Paint getPaint() {
        return this.g2d.getPaint();
    }

    public Graphics setPaint(Paint paint) {
        this.g2d.setPaint(paint);
        return this;
    }

    public Stroke getStroke() {
        return this.g2d.getStroke();
    }

    public Graphics setStroke(Stroke stroke) {
        this.g2d.setStroke(stroke);
        return this;
    }

    public void clip() {
        int x = (int)((double)this.projection.width * this.projection.canvas.margin);
        int y = (int)((double)this.projection.height * this.projection.canvas.margin);
        int w = (int)((double)this.projection.width * (1.0 - 2.0 * this.projection.canvas.margin));
        int h = (int)((double)this.projection.height * (1.0 - 2.0 * this.projection.canvas.margin));
        this.originalClip = this.g2d.getClip();
        this.g2d.clipRect(x, y, w, h);
    }

    public void clearClip() {
        this.g2d.setClip(this.originalClip);
        this.originalClip = null;
    }

    public void drawText(String label, double[] coord) {
        this.drawText(label, coord, 0.5, 0.5, 0.0);
    }

    public void drawText(String label, double[] coord, double rotation) {
        this.drawText(label, coord, 0.5, 0.5, rotation);
    }

    public void drawText(String label, double[] coord, double horizontalReference, double verticalReference) {
        this.drawText(label, coord, horizontalReference, verticalReference, 0.0);
    }

    public void drawText(String label, double[] coord, double horizontalReference, double verticalReference, double rotation) {
        int[] sc = this.projection.screenProjection(coord);
        int x = sc[0];
        int y = sc[1];
        AffineTransform transform = this.g2d.getTransform();
        FontRenderContext frc = this.g2d.getFontRenderContext();
        Font font = this.g2d.getFont();
        double w = font.getStringBounds(label, frc).getWidth();
        double h = font.getSize2D();
        if (rotation != 0.0) {
            this.g2d.rotate(rotation, x, y);
        }
        this.g2d.drawString(label, x -= (int)(w * horizontalReference), y += (int)(h * verticalReference));
        this.g2d.setTransform(transform);
    }

    public void drawTextBaseRatio(String label, double[] coord) {
        this.drawTextBaseRatio(label, coord, 0.5, 0.5, 0.0);
    }

    public void drawTextBaseRatio(String label, double[] coord, double rotation) {
        this.drawTextBaseRatio(label, coord, 0.5, 0.5, 0.0);
    }

    public void drawTextBaseRatio(String label, double[] coord, double horizontalReference, double verticalReference) {
        this.drawTextBaseRatio(label, coord, horizontalReference, verticalReference, 0.0);
    }

    public void drawTextBaseRatio(String label, double[] coord, double horizontalReference, double verticalReference, double rotation) {
        int[] sc = this.projection.screenProjectionBaseRatio(coord);
        int x = sc[0];
        int y = sc[1];
        AffineTransform transform = this.g2d.getTransform();
        FontRenderContext frc = this.g2d.getFontRenderContext();
        Font font = this.g2d.getFont();
        double w = font.getStringBounds(label, frc).getWidth();
        double h = font.getSize2D();
        if (rotation != 0.0) {
            this.g2d.rotate(rotation, x, y);
        }
        this.g2d.drawString(label, x -= (int)(w * horizontalReference), y += (int)(h * verticalReference));
        this.g2d.setTransform(transform);
    }

    private void drawLine(int[] ... coord) {
        int[] x = new int[coord.length];
        for (int i = 0; i < coord.length; ++i) {
            x[i] = coord[i][0];
        }
        int[] y = new int[coord.length];
        for (int i = 0; i < coord.length; ++i) {
            y[i] = coord[i][1];
        }
        this.g2d.drawPolyline(x, y, coord.length);
    }

    public void drawLine(double[] ... coord) {
        int[][] sc = new int[coord.length][];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = this.projection.screenProjection(coord[i]);
        }
        this.drawLine(sc);
    }

    public void drawLineBaseRatio(double[] ... coord) {
        int[][] sc = new int[coord.length][];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = this.projection.screenProjectionBaseRatio(coord[i]);
        }
        this.drawLine(sc);
    }

    public void drawPoint(double ... coord) {
        this.drawPoint('.', coord);
    }

    public void drawPoint(char dot, double ... coord) {
        int size = 2;
        int midSize = 3;
        int bigSize = 4;
        int[] sc = this.projection.screenProjection(coord);
        int x = sc[0];
        int y = sc[1];
        switch (dot) {
            case '+': {
                this.g2d.drawLine(x - size, y, x + size, y);
                this.g2d.drawLine(x, y - size, x, y + size);
                break;
            }
            case '-': {
                this.g2d.drawLine(x - size, y, x + size, y);
                break;
            }
            case '|': {
                this.g2d.drawLine(x, y - size, x, y + size);
                break;
            }
            case 'x': {
                this.g2d.drawLine(x - size, y - size, x + size, y + size);
                this.g2d.drawLine(x + size, y - size, x - size, y + size);
                break;
            }
            case '*': {
                this.g2d.drawLine(x - bigSize, y, x + bigSize, y);
                this.g2d.drawLine(x, y - bigSize, x, y + bigSize);
                this.g2d.drawLine(x - midSize, y - midSize, x + midSize, y + midSize);
                this.g2d.drawLine(x + midSize, y - midSize, x - midSize, y + midSize);
                break;
            }
            case 'o': {
                this.g2d.drawOval(x - size, y - size, 2 * size, 2 * size);
                break;
            }
            case 'O': {
                this.g2d.drawOval(x - bigSize, y - bigSize, 2 * bigSize, 2 * bigSize);
                break;
            }
            case '@': {
                this.g2d.fillOval(x - size, y - size, 2 * size, 2 * size);
                break;
            }
            case '#': {
                this.g2d.fillOval(x - bigSize, y - bigSize, 2 * bigSize, 2 * bigSize);
                break;
            }
            case 's': {
                this.g2d.drawRect(x - size, y - size, 2 * size, 2 * size);
                break;
            }
            case 'S': {
                this.g2d.drawRect(x - bigSize, y - bigSize, 2 * bigSize, 2 * bigSize);
                break;
            }
            case 'q': {
                this.g2d.fillRect(x - size, y - size, 2 * size, 2 * size);
                break;
            }
            case 'Q': {
                this.g2d.fillRect(x - bigSize, y - bigSize, 2 * bigSize, 2 * bigSize);
                break;
            }
            default: {
                this.g2d.drawRect(x, y, 1, 1);
            }
        }
    }

    public void drawPolygon(double[] ... coord) {
        int[][] c = new int[coord.length][2];
        for (int i = 0; i < coord.length; ++i) {
            c[i] = this.projection.screenProjection(coord[i]);
        }
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
        }
        this.g2d.drawPolygon(x, y, c.length);
    }

    public void fillPolygon(double[] ... coord) {
        int[][] c = new int[coord.length][2];
        for (int i = 0; i < coord.length; ++i) {
            c[i] = this.projection.screenProjection(coord[i]);
        }
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
        }
        this.g2d.fillPolygon(x, y, c.length);
    }

    public void fillPolygon(float alpha, double[] ... coord) {
        int[][] c = new int[coord.length][2];
        for (int i = 0; i < coord.length; ++i) {
            c[i] = this.projection.screenProjection(coord[i]);
        }
        int[] x = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            x[i] = c[i][0];
        }
        int[] y = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            y[i] = c[i][1];
        }
        Composite cs = this.g2d.getComposite();
        this.g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        this.g2d.fillPolygon(x, y, c.length);
        this.g2d.setComposite(cs);
    }

    public void drawRect(double[] topLeft, double[] rightBottom) {
        if (!(this.projection instanceof Projection2D)) {
            throw new UnsupportedOperationException("Only 2D graphics supports drawing rectangles.");
        }
        int[] sc = this.projection.screenProjection(topLeft);
        int[] sc2 = this.projection.screenProjection(rightBottom);
        this.g2d.drawRect(sc[0], sc[1], sc2[0] - sc[0], sc2[1] - sc[1]);
    }

    public void drawRectBaseRatio(double[] topLeft, double[] rightBottom) {
        if (!(this.projection instanceof Projection2D)) {
            throw new UnsupportedOperationException("Only 2D graphics supports drawing rectangles.");
        }
        int[] sc = this.projection.screenProjectionBaseRatio(topLeft);
        int[] sc2 = this.projection.screenProjectionBaseRatio(rightBottom);
        this.g2d.drawRect(sc[0], sc[1], sc2[0] - sc[0], sc2[1] - sc[1]);
    }

    public void fillRect(double[] topLeft, double[] rightBottom) {
        if (!(this.projection instanceof Projection2D)) {
            throw new UnsupportedOperationException("Only 2D graphics supports drawing rectangles.");
        }
        int[] sc = this.projection.screenProjection(topLeft);
        int[] sc2 = this.projection.screenProjection(rightBottom);
        this.g2d.fillRect(sc[0], sc[1], sc2[0] - sc[0], sc2[1] - sc[1]);
    }

    public void fillRectBaseRatio(double[] topLeft, double[] rightBottom) {
        if (!(this.projection instanceof Projection2D)) {
            throw new UnsupportedOperationException("Only 2D graphics supports drawing rectangles.");
        }
        int[] sc = this.projection.screenProjectionBaseRatio(topLeft);
        int[] sc2 = this.projection.screenProjectionBaseRatio(rightBottom);
        this.g2d.fillRect(sc[0], sc[1], sc2[0] - sc[0], sc2[1] - sc[1]);
    }

    public void rotate(double x, double y) {
        if (!(this.projection instanceof Projection3D)) {
            throw new UnsupportedOperationException("Only 3D graphics supports rotation.");
        }
        ((Projection3D)this.projection).rotate(x, y);
    }
}

