/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;

public class Grid
extends Plot {
    private double[][][] data;

    public Grid(double[][][] data, Color color) {
        super(color);
        this.data = data;
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        g.setColor(this.color);
        for (i = 0; i < this.data.length; ++i) {
            for (j = 0; j < this.data[i].length - 1; ++j) {
                g.drawLine(this.data[i][j], this.data[i][j + 1]);
            }
        }
        for (i = 0; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                g.drawLine(this.data[i][j], this.data[i + 1][j]);
            }
        }
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{this.data[0][0][0], this.data[0][0][1]};
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                if (this.data[i][j][0] < bound[0]) {
                    bound[0] = this.data[i][j][0];
                }
                if (!(this.data[i][j][1] < bound[1])) continue;
                bound[1] = this.data[i][j][1];
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{this.data[0][0][0], this.data[0][0][1]};
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                if (this.data[i][j][0] > bound[0]) {
                    bound[0] = this.data[i][j][0];
                }
                if (!(this.data[i][j][1] > bound[1])) continue;
                bound[1] = this.data[i][j][1];
            }
        }
        return bound;
    }

    public static Grid of(double[][][] data) {
        return new Grid(data, Color.BLACK);
    }
}

