/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.util.ArrayList;
import java.util.List;
import smile.plot.swing.Graphics;
import smile.plot.swing.Label;
import smile.plot.swing.Shape;

public class Isoline
extends Shape {
    final double level;
    private List<double[]> points = new ArrayList<double[]>();
    private Label label;
    private boolean isLevelVisible;

    public Isoline(double level, boolean isLevelVisible) {
        this.level = level;
        this.isLevelVisible = isLevelVisible;
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public void add(double ... point) {
        this.points.add(point);
    }

    @Override
    public void paint(Graphics g) {
        double angle = 0.0;
        double horizontalReference = 0.0;
        double verticalReference = 0.0;
        double[] coord = null;
        if (this.points.size() > 1) {
            x1 = this.points.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                double[] x2 = this.points.get(i);
                g.drawLine(x1, x2);
                x1 = x2;
                if (this.label != null || i != this.points.size() / 2) continue;
                coord = x1;
                int k = i + 1;
                if (k >= this.points.size()) {
                    k = i;
                }
                angle = 1.5707963267948966;
                double dxx = this.points.get(k)[0] - this.points.get(i)[0];
                double dyy = this.points.get(k)[1] - this.points.get(i)[1];
                if (dyy < 0.0) {
                    angle = -1.5707963267948966;
                }
                if (dxx == 0.0) continue;
                angle = Math.atan(dyy / dxx) + 1.5707963267948966;
            }
        } else if (this.points.size() == 1) {
            x1 = this.points.get(0);
            g.drawPoint('@', x1);
            coord = x1;
            horizontalReference = 0.0;
        }
        if (this.isLevelVisible && this.label == null) {
            double[] lb = g.getLowerBound();
            double[] ub = g.getUpperBound();
            double xrange = ub[0] - lb[0];
            double yrange = ub[1] - lb[1];
            if (ub[0] - coord[0] < xrange / 10.0) {
                horizontalReference = 1.0;
            }
            if (ub[1] - coord[1] < yrange / 10.0) {
                horizontalReference = 1.0;
            }
            if (coord[1] - lb[1] < yrange / 10.0) {
                horizontalReference = 0.0;
            }
            this.label = Label.of(String.format("%.2G", this.level), coord, horizontalReference, verticalReference, angle);
        }
        if (this.label != null) {
            this.label.paint(g);
        }
    }
}

