/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Background {
    final ObjectNode spec;

    Background(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Background style(String ... style) {
        if (style.length == 1) {
            this.spec.put("style", style[0]);
        } else {
            ArrayNode node = this.spec.putArray("style");
            for (String s : style) {
                node.add(s);
            }
        }
        return this;
    }

    public Background cornerRadius(int cornerRadius) {
        this.spec.put("cornerRadius", cornerRadius);
        return this;
    }

    public Background cursor(String cursor) {
        this.spec.put("cursor", cursor);
        return this;
    }

    public Background fill(String color) {
        this.spec.put("fill", color);
        return this;
    }

    public Background fillOpacity(double opacity) {
        this.spec.put("fillOpacity", opacity);
        return this;
    }

    public Background opacity(double opacity) {
        this.spec.put("opacity", opacity);
        return this;
    }

    public Background stroke(String color) {
        this.spec.put("stroke", color);
        return this;
    }

    public Background strokeCap(String cap) {
        this.spec.put("strokeCap", cap);
        return this;
    }

    public Background strokeDash(double stroke, double space) {
        this.spec.putArray("strokeDash").add(stroke).add(space);
        return this;
    }

    public Background strokeDashOffset(int offset) {
        this.spec.put("strokeDashOffset", offset);
        return this;
    }

    public Background strokeJoin(String join) {
        this.spec.put("strokeJoin", join);
        return this;
    }

    public Background strokeMiterLimit(int limit) {
        this.spec.put("strokeMiterLimit", limit);
        return this;
    }

    public Background strokeOpacity(double opacity) {
        this.spec.put("strokeOpacity", opacity);
        return this;
    }

    public Background strokeWidth(int width) {
        this.spec.put("strokeWidth", width);
        return this;
    }
}

