/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.Axis;
import smile.plot.vega.FormatConfig;
import smile.plot.vega.Legend;

public class Config {
    final ObjectNode spec;

    Config(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Config autosize() {
        return this.autosize("pad", false, "content");
    }

    public Config autosize(String type, boolean resize, String contains) {
        ObjectNode autosize = this.spec.putObject("autosize");
        autosize.put("type", type);
        autosize.put("resize", resize);
        autosize.put("contains", contains);
        return this;
    }

    public Config background(String color) {
        this.spec.put("background", color);
        return this;
    }

    public Config padding(int size) {
        this.spec.put("padding", size);
        return this;
    }

    public Config padding(int left, int top, int right, int bottom) {
        ObjectNode padding = this.spec.putObject("padding");
        padding.put("left", left);
        padding.put("top", top);
        padding.put("right", right);
        padding.put("bottom", bottom);
        return this;
    }

    public Config countTitle(String title) {
        this.spec.put("countTitle", title);
        return this;
    }

    public Config fieldTitle(String title) {
        this.spec.put("fieldTitle", title);
        return this;
    }

    public Config font(String font) {
        this.spec.put("font", font);
        return this;
    }

    public Config lineBreak(String lineBreak) {
        this.spec.put("lineBreak", lineBreak);
        return this;
    }

    public FormatConfig tooltipFormat() {
        ObjectNode node = this.spec.putObject("tooltipFormat");
        return new FormatConfig(node);
    }

    public Axis axis() {
        ObjectNode node = this.spec.has("axis") ? (ObjectNode)this.spec.get("axis") : this.spec.putObject("axis");
        return new Axis(node);
    }

    public Legend legend() {
        ObjectNode node = this.spec.has("legend") ? (ObjectNode)this.spec.get("legend") : this.spec.putObject("legend");
        return new Legend(node);
    }
}

