/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import smile.plot.vega.VegaLite;

public class Data {
    final ObjectNode spec = VegaLite.mapper.createObjectNode();

    Data() {
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Data name(String name) {
        this.spec.put("name", name);
        return this;
    }

    public Data url(String url) {
        this.spec.put("url", url);
        return this;
    }

    public Data format(String format) {
        this.spec.putObject("format").put("type", format);
        return this;
    }

    public Data format(String format, Map<String, String> type) {
        ObjectNode node = this.spec.putObject("format");
        node.put("type", format);
        if (type == null) {
            node.putNull("parse");
        } else {
            ObjectNode parse = node.putObject("parse");
            for (Map.Entry<String, String> entry : type.entrySet()) {
                parse.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Data values(String json) throws JsonProcessingException {
        this.spec.set("values", VegaLite.mapper.valueToTree((Object)json));
        return this;
    }

    public <T> Data values(T[] data) {
        this.spec.set("values", VegaLite.mapper.valueToTree(data));
        return this;
    }

    public <T> Data values(List<T> data) {
        this.spec.set("values", VegaLite.mapper.valueToTree(data));
        return this;
    }

    public Data json(String url, String property) {
        this.spec.put("url", url);
        this.spec.putObject("format").put("type", "json").put("property", property);
        return this;
    }

    public Data topojson(String url, String conversion, String name) {
        this.spec.put("url", url);
        this.spec.putObject("format").put("type", "topojson").put(conversion, name);
        return this;
    }

    public Data csv(String url, Map<String, String> type) {
        return this.url(url).format("csv", type);
    }

    public Data tsv(String url, Map<String, String> type) {
        return this.url(url).format("tsv", type);
    }

    public Data dsv(String url, String delimiter) {
        this.url(url).format("dsv");
        ((ObjectNode)this.spec.get("format")).put("delimiter", delimiter);
        return this;
    }

    public Data dsv(String url, String delimiter, Map<String, String> type) {
        this.url(url).format("dsv", type);
        ((ObjectNode)this.spec.get("format")).put("delimiter", delimiter);
        return this;
    }
}

