/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ObjectNode;

public class FacetField {
    final ObjectNode spec;

    FacetField(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public FacetField type(String type) {
        this.spec.put("type", type);
        return this;
    }

    public FacetField bin(boolean flag) {
        this.spec.put("bin", flag);
        return this;
    }

    public FacetField bin(String bin) {
        assert (bin == "binned") : "Invalid bin: " + bin;
        this.spec.put("bin", bin);
        return this;
    }

    public FacetField timeUnit(String timeUnit) {
        this.spec.put("timeUnit", timeUnit);
        return this;
    }

    public FacetField header(String title) {
        ObjectNode node = this.spec.putObject("header");
        node.put("title", title);
        return this;
    }

    public FacetField align(String alignment) {
        this.spec.put("align", alignment);
        return this;
    }

    public FacetField center(boolean flag) {
        this.spec.put("center", flag);
        return this;
    }

    public FacetField spacing(double spacing) {
        this.spec.put("spacing", spacing);
        return this;
    }

    public FacetField spacing(int columns) {
        this.spec.put("columns", columns);
        return this;
    }
}

