/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.Axis;
import smile.plot.vega.BinParams;
import smile.plot.vega.Legend;

public class Field {
    final ObjectNode spec;

    Field(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Field type(String type) {
        this.spec.put("type", type);
        return this;
    }

    public Field bin(boolean flag) {
        this.spec.put("bin", flag);
        return this;
    }

    public Field bin(String bin) {
        assert (bin == "binned") : "Invalid bin: " + bin;
        this.spec.put("bin", bin);
        return this;
    }

    public Field bin(BinParams params) {
        this.spec.set("bin", (JsonNode)params.spec);
        return this;
    }

    public Field timeUnit(String timeUnit) {
        this.spec.put("timeUnit", timeUnit);
        return this;
    }

    public Field aggregate(String aggregate) {
        this.spec.put("aggregate", aggregate);
        return this;
    }

    public Field title(String title) {
        this.spec.put("title", title);
        return this;
    }

    public Field scale(String type) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("type", type);
        return this;
    }

    public Field zero(boolean flag) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("zero", flag);
        return this;
    }

    public Field domain(double ... values) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        ArrayNode domain = node.putArray("domain");
        for (double value : values) {
            domain.add(value);
        }
        return this;
    }

    public Field domain(String ... values) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        ArrayNode domain = node.putArray("domain");
        for (String value : values) {
            domain.add(value);
        }
        return this;
    }

    public Field domainMin(double min) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("domainMin", min);
        return this;
    }

    public Field domainMin(String min) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("domainMin", min);
        return this;
    }

    public Field domainMax(double max) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("domainMax", max);
        return this;
    }

    public Field domainMax(String max) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("domainMax", max);
        return this;
    }

    public Field range(double ... values) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        ArrayNode range = node.putArray("range");
        for (double value : values) {
            range.add(value);
        }
        return this;
    }

    public Field range(String ... values) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        ArrayNode range = node.putArray("range");
        for (String value : values) {
            range.add(value);
        }
        return this;
    }

    public Field rangeMin(double min) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("rangeMin", min);
        return this;
    }

    public Field rangeMin(String min) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("rangeMin", min);
        return this;
    }

    public Field rangeMax(double max) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("rangeMax", max);
        return this;
    }

    public Field rangeMax(String max) {
        ObjectNode node = this.spec.has("scale") ? (ObjectNode)this.spec.get("scale") : this.spec.putObject("scale");
        node.put("rangeMax", max);
        return this;
    }

    public Field sort(String value) {
        this.spec.put("sort", value);
        return this;
    }

    public Field stack(String type) {
        this.spec.put("stack", type);
        return this;
    }

    public Field spacing(double spacing) {
        this.spec.put("spacing", spacing);
        return this;
    }

    public Axis axis() {
        ObjectNode node = this.spec.has("axis") ? (ObjectNode)this.spec.get("axis") : this.spec.putObject("axis");
        return new Axis(node);
    }

    public Legend legend() {
        ObjectNode node = this.spec.has("legend") ? (ObjectNode)this.spec.get("legend") : this.spec.putObject("legend");
        return new Legend(node);
    }

    public Field removeLegend() {
        this.spec.putNull("legend");
        return this;
    }
}

