/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class QuantileTransform {
    final ObjectNode spec;

    QuantileTransform(ObjectNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public QuantileTransform step(double step) {
        this.spec.put("step", step);
        return this;
    }

    public QuantileTransform probs(double[] probs) {
        ArrayNode node = this.spec.putArray("probs");
        for (double prob : probs) {
            node.add(prob);
        }
        return this;
    }

    public QuantileTransform groupby(String ... fields) {
        ArrayNode node = this.spec.putArray("groupby");
        for (String field : fields) {
            node.add(field);
        }
        return this;
    }

    public QuantileTransform as(String ... fields) {
        ArrayNode node = this.spec.putArray("as");
        for (String field : fields) {
            node.add(field);
        }
        return this;
    }
}

