/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import smile.plot.vega.Data;
import smile.plot.vega.DensityTransform;
import smile.plot.vega.ImputeTransform;
import smile.plot.vega.LoessTransform;
import smile.plot.vega.LookupData;
import smile.plot.vega.PivotTransform;
import smile.plot.vega.Predicate;
import smile.plot.vega.QuantileTransform;
import smile.plot.vega.RegressionTransform;
import smile.plot.vega.StackTransform;
import smile.plot.vega.VegaLite;
import smile.plot.vega.WindowTransform;
import smile.plot.vega.WindowTransformField;

public class Transform {
    final ArrayNode spec;

    Transform(ArrayNode spec) {
        this.spec = spec;
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public Transform aggregate(String op, String field, String as, String ... groupby) {
        ObjectNode node = this.spec.addObject();
        ArrayNode a = node.putArray("aggregate");
        a.addObject().put("op", op).put("field", field).put("as", as);
        ArrayNode g = node.putArray("groupby");
        for (String f : groupby) {
            g.add(f);
        }
        return this;
    }

    public Transform joinAggregate(String op, String field, String as, String ... groupby) {
        ObjectNode node = this.spec.addObject();
        ArrayNode a = node.putArray("joinaggregate");
        a.addObject().put("op", op).put("field", field).put("as", as);
        ArrayNode g = node.putArray("groupby");
        for (String f : groupby) {
            g.add(f);
        }
        return this;
    }

    public Transform bin(String field, String as) {
        ObjectNode node = this.spec.addObject();
        node.put("bin", true).put("field", field).put("as", as);
        return this;
    }

    public Transform calculate(String expr, String field) {
        ObjectNode node = this.spec.addObject();
        node.put("calculate", expr);
        node.put("as", field);
        return this;
    }

    public DensityTransform density(String field, String ... groupby) {
        ObjectNode node = this.spec.addObject().put("density", field);
        if (groupby.length > 0) {
            ArrayNode array = node.putArray("groupby");
            for (String f : groupby) {
                array.add(f);
            }
        }
        return new DensityTransform(node);
    }

    public Transform extent(String field, String param) {
        ObjectNode node = this.spec.addObject();
        node.put("extent", field).put("param", param);
        return this;
    }

    public Transform flatten(String[] fields, String[] output) {
        ObjectNode node = this.spec.addObject();
        ArrayNode array = node.putArray("flatten");
        for (String field : fields) {
            array.add(field);
        }
        array = node.putArray("as");
        for (String field : output) {
            array.add(field);
        }
        return this;
    }

    public Transform fold(String[] fields, String[] output) {
        ObjectNode node = this.spec.addObject();
        ArrayNode array = node.putArray("fold");
        for (String field : fields) {
            array.add(field);
        }
        array = node.putArray("as");
        for (String field : output) {
            array.add(field);
        }
        return this;
    }

    public Transform filter(String predicate) {
        ObjectNode node = this.spec.addObject();
        node.put("filter", predicate);
        return this;
    }

    public Transform filter(Predicate predicate) {
        ObjectNode node = this.spec.addObject();
        node.set("filter", (JsonNode)predicate.spec);
        return this;
    }

    public ImputeTransform impute(String field, String key) {
        ObjectNode node = this.spec.addObject().put("impute", field);
        node.put("key", key);
        return new ImputeTransform(node);
    }

    public LoessTransform loess(String field, String on) {
        ObjectNode node = this.spec.addObject().put("loess", field);
        node.put("on", on);
        return new LoessTransform(node);
    }

    public Transform lookup(String key, String param) {
        ObjectNode node = this.spec.addObject();
        node.put("lookup", key);
        node.putObject("from").put("param", param);
        return this;
    }

    public Transform lookup(String key, LookupData from) {
        ObjectNode node = this.spec.addObject();
        node.put("lookup", key).set("from", (JsonNode)from.spec);
        return this;
    }

    public LookupData lookupData(String key) {
        ObjectNode node = VegaLite.mapper.createObjectNode().put("key", key);
        Data data = new Data();
        node.set("data", (JsonNode)data.spec);
        return new LookupData(node, data);
    }

    public PivotTransform pivot(String field, String value) {
        ObjectNode node = this.spec.addObject().put("pivot", field);
        node.put("value", value);
        return new PivotTransform(node);
    }

    public QuantileTransform quantile(String field) {
        ObjectNode node = this.spec.addObject().put("quantile", field);
        return new QuantileTransform(node);
    }

    public RegressionTransform regression(String field, String on) {
        ObjectNode node = this.spec.addObject().put("regression", field);
        node.put("on", on);
        return new RegressionTransform(node);
    }

    public Transform sample(int size) {
        this.spec.addObject().put("sample", size);
        return this;
    }

    public StackTransform stack(String field, String as, String ... groupby) {
        ObjectNode node = this.spec.addObject().put("stack", field);
        ArrayNode g = node.putArray("groupby");
        for (String f : groupby) {
            g.add(f);
        }
        node.put("as", as);
        return new StackTransform(node);
    }

    public Transform timeUnit(String timeUnit, String field, String as) {
        this.spec.addObject().put("timeUnit", timeUnit).put("field", field).put("as", as);
        return this;
    }

    public WindowTransform window(WindowTransformField ... fields) {
        ObjectNode node = this.spec.addObject();
        ArrayNode array = node.putArray("window");
        for (WindowTransformField field : fields) {
            array.addObject().put("op", field.op()).put("field", field.field()).put("param", field.param()).put("as", field.as());
        }
        return new WindowTransform(node);
    }
}

