/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.vega;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.plot.vega.Config;
import smile.plot.vega.Data;
import smile.plot.vega.Transform;
import smile.plot.vega.ViewConfig;
import smile.util.Strings;

public class VegaLite {
    private static final Logger logger = LoggerFactory.getLogger(VegaLite.class);
    private static final String schema = "https://vega.github.io/schema/vega-lite/v5.json";
    private static final String mime = "application/vnd.vegalite.v5+json";
    static final DateTimeFormatter ISO8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
    static final ObjectMapper mapper = new ObjectMapper();
    final ObjectNode spec = mapper.createObjectNode();
    final ObjectNode config = this.spec.putObject("config");
    final ObjectNode view = this.config.putObject("view");

    public VegaLite() {
        this.spec.put("$schema", schema);
        this.view.put("continuousWidth", 400);
        this.view.put("continuousHeight", 400);
    }

    public String toString() {
        return this.spec.toString();
    }

    public String toPrettyString() {
        return this.spec.toPrettyString();
    }

    public ObjectNode spec() {
        return this.spec;
    }

    public Config config() {
        return new Config(this.config);
    }

    public ViewConfig viewConfig() {
        return new ViewConfig(this.view);
    }

    public VegaLite usermeta(JsonNode metadata) {
        this.spec.set("usermeta", metadata);
        return this;
    }

    public VegaLite usermeta(Object metadata) {
        this.spec.putPOJO("usermeta", metadata);
        return this;
    }

    public VegaLite background(String color) {
        this.spec.put("background", color);
        return this;
    }

    public VegaLite padding(int size) {
        this.spec.put("padding", size);
        return this;
    }

    public VegaLite padding(int left, int top, int right, int bottom) {
        ObjectNode padding = this.spec.putObject("padding");
        padding.put("left", left);
        padding.put("top", top);
        padding.put("right", right);
        padding.put("bottom", bottom);
        return this;
    }

    public VegaLite autosize() {
        return this.autosize("pad", false, "content");
    }

    public VegaLite autosize(String type, boolean resize, String contains) {
        ObjectNode autosize = this.spec.putObject("autosize");
        autosize.put("type", type);
        autosize.put("resize", resize);
        autosize.put("contains", contains);
        return this;
    }

    public VegaLite name(String name) {
        this.spec.put("name", name);
        return this;
    }

    public VegaLite description(String description) {
        this.spec.put("description", description);
        return this;
    }

    public VegaLite title(String title) {
        this.spec.put("title", title);
        return this;
    }

    public Data data() {
        Data data = new Data();
        this.spec.set("data", (JsonNode)data.spec);
        return data;
    }

    public Transform transform() {
        ArrayNode node = this.spec.has("transform") ? (ArrayNode)this.spec.get("transform") : this.spec.putArray("transform");
        return new Transform(node);
    }

    public void show() throws IOException, HeadlessException {
        this.show(false);
    }

    public void show(boolean silent) throws IOException, HeadlessException {
        try {
            Path path = Files.createTempFile("smile-plot-", ".html", new FileAttribute[0]);
            path.toFile().deleteOnExit();
            Files.write(path, this.html().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Desktop.getDesktop().browse(path.toUri());
        }
        catch (Exception ex) {
            if (silent) {
                logger.warn("Failed to show " + this.getClass().getSimpleName(), (Throwable)ex);
            }
            throw ex;
        }
    }

    public String html() throws JsonProcessingException {
        return this.html("en");
    }

    public String html(String lang) throws JsonProcessingException {
        String title = this.spec.has("title") ? this.spec.get("title").asText() : "Smile Plot";
        return String.format("   <!DOCTYPE html>\n   <html lang=%s>\n   <head>\n     <title>%s</title>\n     <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n     <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vega@5\"></script>\n     <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vega-lite@5\"></script>\n     <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vega-embed@6\"></script>\n   </head>\n   <body>\n\n   <div id=\"vega-lite\"></div>\n\n   <script type=\"text/javascript\">\n     var spec = %s;\n     var opt = {\n       \"mode\": \"vega-lite\",\n       \"renderer\": \"canvas\",\n       \"actions\": {\"editor\": true, \"source\": true, \"export\": true}\n     };\n     vegaEmbed('#vega-lite', spec, opt).catch(console.error);\n   </script>\n   </body>\n   </html>\n", lang, title, this.spec.toPrettyString());
    }

    public String iframe() throws JsonProcessingException {
        return this.iframe(UUID.randomUUID().toString());
    }

    public String iframe(String id) throws JsonProcessingException {
        String src = Strings.htmlEscape((String)this.html());
        return String.format("   <iframe id=\"%s\" sandbox=\"allow-scripts allow-same-origin\" style=\"border: none; width: 100%\" srcdoc=\"%s\"></iframe>\n   <script>\n     (function() {\n       function resizeIFrame(el, k) {\n         var height = el.contentWindow.document.body.scrollHeight || '600'; // Fallback in case of no scroll height\n         el.style.height = height + 'px';\n         if (k <= 10) { setTimeout(function() { resizeIFrame(el, k+1) }, 100 + (k * 250)) };\n       }\n       resizeIFrame(document.getElementById(\"%s\"), 1);\n     })(); // IIFE\n   </script>\n", id, src, id);
    }

    ObjectNode encoding() {
        return this.spec.has("encoding") ? (ObjectNode)this.spec.get("encoding") : this.spec.putObject("encoding");
    }
}

