/*
 * Decompiled with CFR 0.152.
 */
package smile.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChooser
extends JFileChooser {
    private static final Logger logger = LoggerFactory.getLogger(FileChooser.class);
    private static FileChooser chooser = new FileChooser();

    public FileChooser() {
        this.setAccessory(new FilePreview(this));
    }

    public static FileChooser getInstance() {
        return chooser;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    class FilePreview
    extends JComponent
    implements PropertyChangeListener {
        BufferedImage img = null;
        File file = null;
        char[] buf = new char[1024];
        Font font = (Font)UIManager.get("Label.font");
        FontMetrics fm = this.getFontMetrics(this.font);
        Color color = (Color)UIManager.get("Label.foreground");
        String header = null;

        public FilePreview(JFileChooser fc) {
            this.setPreferredSize(new Dimension(160, 160));
            fc.addPropertyChangeListener(this);
        }

        public void loadPreview() {
            if (this.file == null) {
                this.img = null;
                this.header = null;
                return;
            }
            if (!this.file.exists()) {
                return;
            }
            if (SimpleFileFilter.readableImageFilter.accept(this.file)) {
                try {
                    this.img = ImageIO.read(this.file);
                }
                catch (IOException ex) {
                    logger.error("Failed to read image {}", (Object)this.file, (Object)ex);
                }
            } else {
                try {
                    FileReader reader = new FileReader(this.file);
                    int len = reader.read(this.buf, 0, this.buf.length);
                    reader.close();
                    boolean binary = false;
                    for (int i = 0; i < len; ++i) {
                        if (this.buf[i] < '\u0000' || this.buf[i] >= '\u001f' || this.buf[i] == '\t' || this.buf[i] == '\n' || this.buf[i] == '\f' || this.buf[i] == '\r') continue;
                        binary = true;
                        break;
                    }
                    if (!binary) {
                        this.header = new String(this.buf, 0, len);
                    }
                }
                catch (IOException ex) {
                    logger.error("Failed to read file {}", (Object)this.file, (Object)ex);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean update = false;
            String prop = e.getPropertyName();
            if ("directoryChanged".equals(prop)) {
                this.file = null;
                update = true;
            } else if ("SelectedFileChangedProperty".equals(prop)) {
                this.file = (File)e.getNewValue();
                update = true;
            }
            if (update) {
                this.img = null;
                this.header = null;
                if (this.isShowing()) {
                    this.loadPreview();
                    this.repaint();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d;
            if (this.img == null || this.header == null) {
                this.loadPreview();
            }
            if (this.img != null) {
                g2d = (Graphics2D)g;
                if (this.getWidth() < this.img.getWidth() || this.getHeight() < this.img.getHeight()) {
                    x = (this.getWidth() - this.img.getWidth()) / 2;
                    y = (this.getHeight() - this.img.getHeight()) / 2;
                    if (x < 5) {
                        x = 5;
                    }
                    if (y < 5) {
                        y = 5;
                    }
                    int width = this.getWidth() - 2 * x;
                    int height = this.getHeight() - 2 * y;
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.drawImage(this.img, x, y, width, height, null);
                } else {
                    x = (this.getWidth() - this.img.getWidth()) / 2;
                    y = (this.getHeight() - this.img.getHeight()) / 2;
                    g2d.drawImage((Image)this.img, x, y, null);
                }
            }
            if (this.header != null) {
                int begin;
                int end;
                g2d = (Graphics2D)g;
                g2d.setFont(this.font);
                g2d.setColor(this.color);
                Insets insets = this.getInsets();
                int x = insets.left;
                int y = insets.top;
                if (x < 5) {
                    x = 5;
                }
                if (y < 5) {
                    y = 5;
                }
                if ((end = this.header.indexOf(10, begin = 0)) == -1) {
                    end = this.header.length();
                }
                while (begin >= 0 && begin < this.header.length() && (y += this.fm.getAscent()) < this.getHeight()) {
                    g2d.drawString(this.header.substring(begin, end), x, y);
                    begin = end + 1;
                    end = this.header.indexOf(10, begin);
                    if (end == -1) {
                        end = this.header.length();
                    }
                    y += this.fm.getDescent() + this.fm.getLeading();
                }
            }
        }
    }

    public static class SimpleFileFilter
    extends FileFilter {
        private static SimpleFileFilter readableImageFilter = new SimpleFileFilter("Readable Images", ImageIO.getReaderFormatNames());
        private static SimpleFileFilter writableImageFilter = new SimpleFileFilter("Writable Images", ImageIO.getWriterFormatNames());
        private TreeSet<String> filters = new TreeSet();
        private String description = null;
        private String fullDescription = null;

        public SimpleFileFilter(String description, String extension) {
            if (description != null) {
                this.setDescription(description);
            }
            if (extension != null) {
                this.addExtension(extension);
            }
        }

        public SimpleFileFilter(String description, String ... filters) {
            if (description != null) {
                this.setDescription(description);
            }
            for (int i = 0; i < filters.length; ++i) {
                this.addExtension(filters[i]);
            }
        }

        public SimpleFileFilter(String description, Collection<String> filters) {
            if (description != null) {
                this.setDescription(description);
            }
            for (String extension : filters) {
                this.addExtension(extension);
            }
        }

        public static SimpleFileFilter getReadableImageFilter() {
            return readableImageFilter;
        }

        public static SimpleFileFilter getWritableImageFIlter() {
            return writableImageFilter;
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FileChooser.getExtension(f);
                if (extension != null) {
                    return this.filters.contains(extension);
                }
            }
            return false;
        }

        public void addExtension(String extension) {
            this.filters.add(extension.toLowerCase());
            this.fullDescription = null;
        }

        @Override
        public String getDescription() {
            if (this.fullDescription == null) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                for (String extension : this.filters) {
                    this.fullDescription = this.fullDescription + "." + extension;
                }
                this.fullDescription = this.fullDescription + ")";
            }
            return this.fullDescription;
        }

        public void setDescription(String description) {
            this.description = description;
            this.fullDescription = null;
        }
    }
}

