/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class IntegerArrayCellEditor
extends DefaultCellEditor {
    private static final Logger LOGGER = Logger.getLogger(IntegerArrayCellEditor.class.getName());
    JFormattedTextField textField = (JFormattedTextField)this.getComponent();

    public IntegerArrayCellEditor() {
        super(new JFormattedTextField());
        DefaultFormatter formatter = new DefaultFormatter(){

            @Override
            public Object stringToValue(String string) throws ParseException {
                int end;
                if ((string = string.trim()).isEmpty()) {
                    throw new ParseException("Empty string", 0);
                }
                int begin = 0;
                char ch = string.charAt(0);
                if (ch == '[' || ch == '{' || ch == '<') {
                    begin = 1;
                }
                if ((ch = string.charAt((end = string.length()) - 1)) == ']' || ch == '}' || ch == '>') {
                    --end;
                }
                string = string.substring(begin, end);
                String[] items = string.split("\\s*[ ,;:]\\s*");
                int[] data = new int[items.length];
                for (int i = 0; i < data.length; ++i) {
                    data[i] = Integer.parseInt(items[i].trim());
                }
                return data;
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                if (value instanceof byte[]) {
                    byte[] data = (byte[])value;
                    if (data.length > 0) {
                        builder.append("[").append(data[0]);
                    }
                    for (int i = 1; i < data.length; ++i) {
                        builder.append(", ").append(data[i]);
                    }
                    builder.append("]");
                } else if (value instanceof short[]) {
                    short[] data = (short[])value;
                    if (data.length > 0) {
                        builder.append("[").append(data[0]);
                    }
                    for (int i = 1; i < data.length; ++i) {
                        builder.append(", ").append(data[i]);
                    }
                    builder.append("]");
                } else if (value instanceof int[]) {
                    int[] data = (int[])value;
                    if (data.length > 0) {
                        builder.append("[").append(data[0]);
                    }
                    for (int i = 1; i < data.length; ++i) {
                        builder.append(", ").append(data[i]);
                    }
                    builder.append("]");
                } else if (value instanceof long[]) {
                    long[] data = (long[])value;
                    if (data.length > 0) {
                        builder.append("[").append(data[0]);
                    }
                    for (int i = 1; i < data.length; ++i) {
                        builder.append(", ").append(data[i]);
                    }
                    builder.append("]");
                } else {
                    throw new ParseException("Unsupport data type: " + String.valueOf(value.getClass()), 0);
                }
                return builder.toString();
            }
        };
        formatter.setOverwriteMode(false);
        this.textField.setFormatterFactory(new DefaultFormatterFactory(formatter));
        this.textField.setHorizontalAlignment(11);
        this.textField.setFocusLostBehavior(3);
        this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this.textField.getActionMap().put("check", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!IntegerArrayCellEditor.this.textField.isEditValid()) {
                    Toolkit.getDefaultToolkit().beep();
                    IntegerArrayCellEditor.this.textField.selectAll();
                } else {
                    try {
                        IntegerArrayCellEditor.this.textField.commitEdit();
                        IntegerArrayCellEditor.this.textField.postActionEvent();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setValue(value);
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof int[]) {
            return o;
        }
        LOGGER.log(Level.FINE, "getCellEditorValue: can't parse {0}", o);
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else {
            Toolkit.getDefaultToolkit().beep();
            this.textField.selectAll();
            return false;
        }
        return super.stopCellEditing();
    }
}

