/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.util.Collection;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import smile.math.MathEx;
import smile.nlp.Corpus;
import smile.nlp.PimpedString;
import smile.nlp.SimpleCorpus;
import smile.nlp.Text;
import smile.nlp.collocation.Bigram;
import smile.nlp.collocation.NGram;
import smile.nlp.package$;
import smile.nlp.pos.HMMPOSTagger;
import smile.nlp.pos.PennTreebankPOS;
import smile.nlp.stemmer.LancasterStemmer;
import smile.nlp.stemmer.PorterStemmer;
import smile.util.package$time$;

public final class package$ {
    public static final package$ MODULE$;
    private final PorterStemmer porter;
    private final LancasterStemmer lancaster;

    static {
        new package$();
    }

    public PimpedString pimpString(String string) {
        return new PimpedString(string);
    }

    public PorterStemmer porter() {
        return this.porter;
    }

    public LancasterStemmer lancaster() {
        return this.lancaster;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleCorpus corpus(Seq<String> text) {
        void var2_2;
        SimpleCorpus corpus2 = new SimpleCorpus();
        text.foreach((Function1)new Serializable(corpus2){
            public static final long serialVersionUID = 0L;
            private final SimpleCorpus corpus$1;

            public final Text apply(String x0$1) {
                String string = x0$1;
                Text text = this.corpus$1.add(new Text(string));
                return text;
            }
            {
                this.corpus$1 = corpus$1;
            }
        });
        return var2_2;
    }

    public Bigram[] bigram(int k, int minFreq, Seq<String> text) {
        return (Bigram[])package$time$.MODULE$.apply("Bi-gram collocation", new Serializable(k, minFreq, text){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int minFreq$1;
            private final Seq text$1;

            public final Bigram[] apply() {
                return Bigram.of((Corpus)package$.MODULE$.corpus((Seq<String>)this.text$1), (int)this.k$1, (int)this.minFreq$1);
            }
            {
                this.k$1 = k$1;
                this.minFreq$1 = minFreq$1;
                this.text$1 = text$1;
            }
        });
    }

    public Bigram[] bigram(double p, int minFreq, Seq<String> text) {
        return (Bigram[])package$time$.MODULE$.apply("Bi-gram collocation", new Serializable(p, minFreq, text){
            public static final long serialVersionUID = 0L;
            private final double p$1;
            private final int minFreq$2;
            private final Seq text$2;

            public final Bigram[] apply() {
                return Bigram.of((Corpus)package$.MODULE$.corpus((Seq<String>)this.text$2), (double)this.p$1, (int)this.minFreq$2);
            }
            {
                this.p$1 = p$1;
                this.minFreq$2 = minFreq$2;
                this.text$2 = text$2;
            }
        });
    }

    public NGram[][] ngram(int maxNGramSize, int minFreq, Seq<String> text) {
        return (NGram[][])package$time$.MODULE$.apply("N-gram collocation", new Serializable(maxNGramSize, minFreq, text){
            public static final long serialVersionUID = 0L;
            private final int maxNGramSize$1;
            private final int minFreq$3;
            private final Seq text$3;

            public final NGram[][] apply() {
                Seq sentences = (Seq)this.text$3.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<String[]> apply(String text) {
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.pimpString(text).sentences()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String[] apply(String sentence) {
                                return (String[])Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.pimpString(sentence).words("none")).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(String word) {
                                        return package$.MODULE$.porter().stripPluralParticiple(word).toLowerCase();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))));
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return NGram.of((Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(sentences).asJava()), (int)this.maxNGramSize$1, (int)this.minFreq$3);
            }
            {
                this.maxNGramSize$1 = maxNGramSize$1;
                this.minFreq$3 = minFreq$3;
                this.text$3 = text$3;
            }
        });
    }

    public PennTreebankPOS[] postag(String[] sentence) {
        return (PennTreebankPOS[])package$time$.MODULE$.apply("PoS tagging with Hidden Markov Model", new Serializable(sentence){
            public static final long serialVersionUID = 0L;
            private final String[] sentence$1;

            public final PennTreebankPOS[] apply() {
                return HMMPOSTagger.getDefault().tag(this.sentence$1);
            }
            {
                this.sentence$1 = sentence$1;
            }
        });
    }

    public double[] vectorize(String[] terms, Map<String, Object> bag3) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])terms).map((Function1)new Serializable(bag3){
            public static final long serialVersionUID = 0L;
            private final Map bag$1;

            public final double apply(String x$1) {
                return BoxesRunTime.unboxToInt((Object)this.bag$1.getOrElse((Object)x$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }));
            }
            {
                this.bag$1 = bag$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public int[] vectorize(String[] terms, Set<String> bag3) {
        return (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])terms).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(bag3){
            public static final long serialVersionUID = 0L;
            private final Set bag$2;

            public final boolean apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String w = (String)tuple2._1();
                    boolean bl = this.bag$2.contains((Object)w);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.bag$2 = bag$2;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<String, Object> x$2) {
                return x$2._2$mcI$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[] df(String[] terms, Map<String, Object>[] corpus2) {
        return (int[])Predef$.MODULE$.refArrayOps((Object[])terms).map((Function1)new Serializable(corpus2){
            public static final long serialVersionUID = 0L;
            private final Map[] corpus$2;

            public final int apply(String term) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.corpus$2).filter((Function1)new Serializable(this, term){
                    public static final long serialVersionUID = 0L;
                    private final String term$1;

                    public final boolean apply(Map<String, Object> x$3) {
                        return x$3.contains((Object)this.term$1);
                    }
                    {
                        this.term$1 = term$1;
                    }
                })).size();
            }
            {
                this.corpus$2 = corpus$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public double smile$nlp$package$$tfidf(double tf, double maxtf, int n, int df2) {
        return tf / maxtf * Math.log((1.0 + (double)n) / (1.0 + (double)df2));
    }

    public double[][] tfidf(double[][] corpus2) {
        int n = Predef$.MODULE$.refArrayOps((Object[])corpus2).size();
        int[] df2 = new int[corpus2[0].length];
        Predef$.MODULE$.refArrayOps((Object[])corpus2).foreach((Function1)new Serializable(df2){
            public static final long serialVersionUID = 0L;
            public final int[] df$1;

            public final int[] apply(double[] bag3) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.df$1.length).foreach$mVc$sp((Function1)new Serializable(this, bag3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.tfidf.2 $outer;
                    private final double[] bag$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (this.bag$4[i] > 0.0) {
                            this.$outer.df$1[i] = this.$outer.df$1[i] + 1;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.bag$4 = bag$4;
                    }
                });
                return this.df$1;
            }
            {
                this.df$1 = df$1;
            }
        });
        return (double[][])Predef$.MODULE$.refArrayOps((Object[])corpus2).map((Function1)new Serializable(n, df2){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final int[] df$1;

            public final double[] apply(double[] bag3) {
                return package$.MODULE$.tfidf(bag3, this.n$1, this.df$1);
            }
            {
                this.n$1 = n$1;
                this.df$1 = df$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public double[] tfidf(double[] bag3, int n, int[] df2) {
        double maxtf = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(bag3).max((Ordering)Ordering.Double$.MODULE$));
        double[] features = new double[bag3.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features.length).foreach$mVc$sp((Function1)new Serializable(bag3, n, df2, maxtf, features){
            public static final long serialVersionUID = 0L;
            private final double[] bag$3;
            private final int n$2;
            private final int[] df$2;
            private final double maxtf$1;
            private final double[] features$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.features$1[i] = package$.MODULE$.smile$nlp$package$$tfidf(this.bag$3[i], this.maxtf$1, this.n$2, this.df$2[i]);
            }
            {
                this.bag$3 = bag$3;
                this.n$2 = n$2;
                this.df$2 = df$2;
                this.maxtf$1 = maxtf$1;
                this.features$1 = features$1;
            }
        });
        MathEx.unitize((double[])features);
        return features;
    }

    private package$() {
        MODULE$ = this;
        this.porter = new PorterStemmer(){

            public String apply(String word) {
                return this.stem(word);
            }
        };
        this.lancaster = new LancasterStemmer(){

            public String apply(String word) {
                return this.stem(word);
            }
        };
    }
}

