/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001u3Aa\u0003\u0007\u0001#!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0004/\u0001\t\u0007I\u0011A\u0018\t\rA\u0002\u0001\u0015!\u0003'\u0011\u001d\t\u0004A1A\u0005\u0002IBa\u0001\u000e\u0001!\u0002\u0013\u0019\u0004bB\u001b\u0001\u0005\u0004%\tA\r\u0005\u0007m\u0001\u0001\u000b\u0011B\u001a\t\u000b]\u0002A\u0011\t\u001d\t\u000b]\u0002A\u0011\u0002#\u0003/5\u000bGO]5y\u001fJ$WM](qi&l\u0017N_1uS>t'BA\u0007\u000f\u0003\u0011i\u0017\r\u001e5\u000b\u0003=\tQa]7jY\u0016\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r!\u001b\u0005Q\"BA\u000e\u001d\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tib$\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0012aA2p[&\u0011\u0011E\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0003eS6\u001c\bcA\n%M%\u0011Q\u0005\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'\u001dJ!\u0001\u000b\u000b\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0003W5\u0002\"\u0001\f\u0001\u000e\u00031AQA\t\u0002A\u0002\r\n\u0011A\\\u000b\u0002M\u0005\u0011a\u000eI\u0001\u0002[V\t1\u0007E\u0002\u0014I\r\n!!\u001c\u0011\u0002\u0003M\f!a\u001d\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005q\"R\"A\u001f\u000b\u0005y\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002A)\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001E\u0003F\u0003F\u0011N+v\u000b\u0005\u0002\u0014\r&\u0011q\t\u0006\u0002\u0005+:LG\u000fC\u0003J\u0015\u0001\u0007!*\u0001\u0002tEB\u00111\n\u0015\b\u0003\u0019:s!\u0001P'\n\u0003UI!a\u0014\u000b\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u000b\u0005=#\u0002\"\u0002+\u000b\u0001\u00041\u0013!A5\t\u000bYS\u0001\u0019\u0001\u0014\u0002\u0003)DQ\u0001\u0017\u0006A\u0002e\u000bA\"\u001b8uKJlW\rZ5bi\u0016\u00042a\u0005\u0013[!\t\u00192,\u0003\u0002])\t9!i\\8mK\u0006t\u0007")
public class MatrixOrderOptimization
implements LazyLogging {
    private final int[] dims;
    private final int n;
    private final int[][] m;
    private final int[][] s;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        MatrixOrderOptimization matrixOrderOptimization = this;
        synchronized (matrixOrderOptimization) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public int n() {
        return this.n;
    }

    public int[][] m() {
        return this.m;
    }

    public int[][] s() {
        return this.s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean[] intermediate = new boolean[this.n()];
        this.toString(sb, 0, this.n() - 1, intermediate);
        return sb.toString();
    }

    private void toString(StringBuilder sb, int i, int j, boolean[] intermediate) {
        block0: {
            if (i == j) break block0;
            sb.append('(');
            this.toString(sb, i, this.s()[i][j], intermediate);
            Object object = !intermediate[i] ? sb.append(this.dims[i]).append('x').append(this.dims[i + 1]) : BoxedUnit.UNIT;
            sb.append(" * ");
            this.toString(sb, this.s()[i][j] + 1, j, intermediate);
            Object object2 = !intermediate[j] ? sb.append(this.dims[j]).append('x').append(this.dims[j + 1]) : BoxedUnit.UNIT;
            sb.append(')');
            intermediate[i] = true;
            intermediate[j] = true;
        }
    }

    public MatrixOrderOptimization(int[] dims) {
        BoxedUnit boxedUnit;
        this.dims = dims;
        LazyLogging.$init$((LazyLogging)this);
        this.n = dims.length - 1;
        this.m = (int[][])Array$.MODULE$.ofDim(this.n(), this.n(), ClassTag$.MODULE$.Int());
        this.s = (int[][])Array$.MODULE$.ofDim(this.n(), this.n(), ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.n()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)l -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.n() - l).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            int j = i + l;
            $this.m()[i][j] = Integer.MAX_VALUE;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(i), j).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)k -> {
                block0: {
                    int cost = this.m()[i][k] + this.m()[k + 1][j] + $this.dims[i] * $this.dims[k + 1] * $this.dims[j + 1];
                    if (cost >= this.m()[i][j]) break block0;
                    $this.m()[i$1][j$13] = cost;
                    $this.s()[i$1][j$13] = k;
                }
            });
        }));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("The minimum cost of matrix multiplication chain: {}", new Object[]{BoxesRunTime.boxToInteger((int)this.m()[0][this.n() - 1])});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

