/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp;

import java.io.Serializable;
import java.util.Collection;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import smile.math.MathEx;
import smile.nlp.Corpus;
import smile.nlp.PimpedString;
import smile.nlp.SimpleCorpus;
import smile.nlp.Text;
import smile.nlp.collocation.Bigram;
import smile.nlp.collocation.NGram;
import smile.nlp.pos.HMMPOSTagger;
import smile.nlp.pos.PennTreebankPOS;
import smile.nlp.stemmer.LancasterStemmer;
import smile.nlp.stemmer.PorterStemmer;
import smile.util.package$time$;

public final class package$ {
    public static package$ MODULE$;
    private final PorterStemmer porter;
    private final LancasterStemmer lancaster;

    static {
        new package$();
    }

    public PimpedString pimpString(String string) {
        return new PimpedString(string);
    }

    public PorterStemmer porter() {
        return this.porter;
    }

    public LancasterStemmer lancaster() {
        return this.lancaster;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleCorpus corpus(Seq<String> text) {
        void var2_2;
        SimpleCorpus corpus = new SimpleCorpus();
        text.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            Text text = corpus.add(new Text(string));
            return text;
        });
        return var2_2;
    }

    public Bigram[] bigram(int k, int minFreq, Seq<String> text) {
        return (Bigram[])package$time$.MODULE$.apply("Bi-gram collocation", (Function0 & Serializable & scala.Serializable)() -> Bigram.of((Corpus)MODULE$.corpus(text), (int)k, (int)minFreq));
    }

    public Bigram[] bigram(double p, int minFreq, Seq<String> text) {
        return (Bigram[])package$time$.MODULE$.apply("Bi-gram collocation", (Function0 & Serializable & scala.Serializable)() -> Bigram.of((Corpus)MODULE$.corpus(text), (double)p, (int)minFreq));
    }

    public NGram[][] ngram(int maxNGramSize, int minFreq, Seq<String> text) {
        return (NGram[][])package$time$.MODULE$.apply("N-gram collocation", (Function0 & Serializable & scala.Serializable)() -> {
            Seq sentences = (Seq)text.flatMap((Function1 & Serializable & scala.Serializable)text -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.pimpString(text).sentences())).map((Function1 & Serializable & scala.Serializable)sentence -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.pimpString((String)sentence).words("none"))).map((Function1 & Serializable & scala.Serializable)word -> package$.MODULE$.porter().stripPluralParticiple(word).toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))), Seq$.MODULE$.canBuildFrom());
            return NGram.of((Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(sentences).asJava()), (int)maxNGramSize, (int)minFreq);
        });
    }

    public PennTreebankPOS[] postag(String[] sentence) {
        return (PennTreebankPOS[])package$time$.MODULE$.apply("PoS tagging with Hidden Markov Model", (Function0 & Serializable & scala.Serializable)() -> HMMPOSTagger.getDefault().tag(sentence));
    }

    public double[] vectorize(String[] terms, Map<String, Object> bag) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])terms)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)package$.$anonfun$vectorize$1(bag, x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public int[] vectorize(String[] terms, Set<String> bag) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])terms)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$vectorize$3(bag, x0$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public int[] df(String[] terms, Map<String, Object>[] corpus) {
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])terms)).map((Function1 & Serializable & scala.Serializable)term -> BoxesRunTime.boxToInteger((int)package$.$anonfun$df$1(corpus, term)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    private double tfidf(double tf, double maxtf, int n, int df) {
        return tf / maxtf * Math.log((1.0 + (double)n) / (1.0 + (double)df));
    }

    public double[][] tfidf(double[][] corpus) {
        int n = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corpus)).size();
        int[] df = new int[corpus[0].length];
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corpus)).foreach((Function1 & Serializable & scala.Serializable)bag -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), df.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block0: {
                    if (!(bag[i] > 0.0)) break block0;
                    df$1[i] = df[i] + 1;
                }
            });
            return df;
        });
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corpus)).map((Function1 & Serializable & scala.Serializable)bag -> MODULE$.tfidf((double[])bag, n, df), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public double[] tfidf(double[] bag, int n, int[] df) {
        double maxtf = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(bag)).max((Ordering)Ordering.Double$.MODULE$));
        double[] features = new double[bag.length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), features.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            features$1[i] = MODULE$.tfidf(bag[i], maxtf, n, df[i]);
        });
        MathEx.unitize((double[])features);
        return features;
    }

    public static final /* synthetic */ double $anonfun$vectorize$1(Map bag$1, String x$1) {
        return BoxesRunTime.unboxToInt((Object)bag$1.getOrElse((Object)x$1, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ boolean $anonfun$vectorize$3(Set bag$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String w = (String)tuple2._1();
        boolean bl = bag$2.contains((Object)w);
        return bl;
    }

    public static final /* synthetic */ int $anonfun$df$1(Map[] corpus$2, String term) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])corpus$2)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains((Object)term))))).size();
    }

    private package$() {
        MODULE$ = this;
        this.porter = new PorterStemmer(){

            public String apply(String word) {
                return this.stem(word);
            }
        };
        this.lancaster = new LancasterStemmer(){

            public String apply(String word) {
                return this.stem(word);
            }
        };
    }
}

