/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.function.ToDoubleBiFunction;
import scala.Function0;
import smile.clustering.CLARANS;
import smile.clustering.DBSCAN;
import smile.clustering.DENCLUE;
import smile.clustering.DeterministicAnnealing;
import smile.clustering.GMeans;
import smile.clustering.HierarchicalClustering;
import smile.clustering.KMeans;
import smile.clustering.KModes;
import smile.clustering.MEC;
import smile.clustering.PartitionClustering;
import smile.clustering.SIB;
import smile.clustering.SpectralClustering;
import smile.clustering.XMeans;
import smile.clustering.linkage.CompleteLinkage;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.SingleLinkage;
import smile.clustering.linkage.UPGMALinkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMALinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.math.distance.Distance;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.math.matrix.DenseMatrix;
import smile.neighbor.RNNSearch;
import smile.util.SparseArray;
import smile.util.package$time$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public HierarchicalClustering hclust(double[][] data, String method) {
        SingleLinkage singleLinkage;
        String string = method;
        if ("single".equals(string)) {
            singleLinkage = SingleLinkage.of((double[][])data);
        } else if ("complete".equals(string)) {
            singleLinkage = CompleteLinkage.of((double[][])data);
        } else {
            boolean bl = "upgma".equals(string) ? true : "average".equals(string);
            if (bl) {
                singleLinkage = UPGMALinkage.of((double[][])data);
            } else {
                boolean bl2 = "upgmc".equals(string) ? true : "centroid".equals(string);
                if (bl2) {
                    singleLinkage = UPGMCLinkage.of((double[][])data);
                } else if ("wpgma".equals(string)) {
                    singleLinkage = WPGMALinkage.of((double[][])data);
                } else {
                    boolean bl3 = "wpgmc".equals(string) ? true : "median".equals(string);
                    if (bl3) {
                        singleLinkage = WPGMCLinkage.of((double[][])data);
                    } else if ("ward".equals(string)) {
                        singleLinkage = WardLinkage.of((double[][])data);
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(30).append("Unknown agglomeration method: ").append(method).toString());
                    }
                }
            }
        }
        SingleLinkage linkage = singleLinkage;
        return (HierarchicalClustering)package$time$.MODULE$.apply("Hierarchical clustering", () -> package$.$anonfun$hclust$1((Linkage)linkage));
    }

    public <T> HierarchicalClustering hclust(T[] data, Distance<T> distance, String method) {
        Linkage linkage = (Linkage)package$time$.MODULE$.apply(new StringBuilder(8).append(method).append(" linkage").toString(), (Function0 & Serializable)() -> {
            SingleLinkage singleLinkage;
            String string = method;
            if ("single".equals(string)) {
                singleLinkage = SingleLinkage.of((Object[])data, (Distance)distance);
            } else if ("complete".equals(string)) {
                singleLinkage = CompleteLinkage.of((Object[])data, (Distance)distance);
            } else {
                boolean bl = "upgma".equals(string) ? true : "average".equals(string);
                if (bl) {
                    singleLinkage = UPGMALinkage.of((Object[])data, (Distance)distance);
                } else {
                    boolean bl2 = "upgmc".equals(string) ? true : "centroid".equals(string);
                    if (bl2) {
                        singleLinkage = UPGMCLinkage.of((Object[])data, (Distance)distance);
                    } else if ("wpgma".equals(string)) {
                        singleLinkage = WPGMALinkage.of((Object[])data, (Distance)distance);
                    } else {
                        boolean bl3 = "wpgmc".equals(string) ? true : "median".equals(string);
                        if (bl3) {
                            singleLinkage = WPGMCLinkage.of((Object[])data, (Distance)distance);
                        } else if ("ward".equals(string)) {
                            singleLinkage = WardLinkage.of((Object[])data, (Distance)distance);
                        } else {
                            throw new IllegalArgumentException(new StringBuilder(30).append("Unknown agglomeration method: ").append(method).toString());
                        }
                    }
                }
            }
            return singleLinkage;
        });
        return (HierarchicalClustering)package$time$.MODULE$.apply("Hierarchical clustering", (Function0 & Serializable)() -> HierarchicalClustering.fit((Linkage)linkage));
    }

    public KModes kmodes(int[][] data, int k, int maxIter, int runs) {
        return (KModes)package$time$.MODULE$.apply("K-Modes", (Function0 & Serializable)() -> (KModes)PartitionClustering.run((int)runs, () -> KModes.fit((int[][])data, (int)k, (int)maxIter)));
    }

    public int kmodes$default$3() {
        return 100;
    }

    public int kmodes$default$4() {
        return 10;
    }

    public KMeans kmeans(double[][] data, int k, int maxIter, double tol, int runs) {
        return (KMeans)package$time$.MODULE$.apply("K-Means", (Function0 & Serializable)() -> (KMeans)PartitionClustering.run((int)runs, () -> KMeans.fit((double[][])data, (int)k, (int)maxIter, (double)tol)));
    }

    public int kmeans$default$3() {
        return 100;
    }

    public double kmeans$default$4() {
        return 1.0E-4;
    }

    public int kmeans$default$5() {
        return 10;
    }

    public XMeans xmeans(double[][] data, int k) {
        return (XMeans)package$time$.MODULE$.apply("X-Means", (Function0 & Serializable)() -> XMeans.fit((double[][])data, (int)k));
    }

    public int xmeans$default$2() {
        return 100;
    }

    public GMeans gmeans(double[][] data, int k) {
        return (GMeans)package$time$.MODULE$.apply("G-Means", (Function0 & Serializable)() -> GMeans.fit((double[][])data, (int)k));
    }

    public int gmeans$default$2() {
        return 100;
    }

    public SIB sib(SparseArray[] data, int k, int maxIter, int runs) {
        return (SIB)package$time$.MODULE$.apply("Sequential information bottleneck", (Function0 & Serializable)() -> (SIB)PartitionClustering.run((int)runs, () -> SIB.fit((SparseArray[])data, (int)k, (int)maxIter)));
    }

    public int sib$default$3() {
        return 100;
    }

    public int sib$default$4() {
        return 8;
    }

    public DeterministicAnnealing dac(double[][] data, int k, double alpha, int maxIter, double tol, double splitTol) {
        return (DeterministicAnnealing)package$time$.MODULE$.apply("Deterministic annealing clustering", (Function0 & Serializable)() -> DeterministicAnnealing.fit((double[][])data, (int)k, (double)alpha, (int)maxIter, (double)tol, (double)splitTol));
    }

    public double dac$default$3() {
        return 0.9;
    }

    public int dac$default$4() {
        return 100;
    }

    public double dac$default$5() {
        return 1.0E-4;
    }

    public double dac$default$6() {
        return 0.01;
    }

    public <T> CLARANS<T> clarans(T[] data, int k, int maxNeighbor, ToDoubleBiFunction<T, T> distance) {
        return (CLARANS)package$time$.MODULE$.apply("CLARANS", (Function0 & Serializable)() -> CLARANS.fit((Object[])data, (int)k, (int)maxNeighbor, (ToDoubleBiFunction)distance));
    }

    public <T> DBSCAN<T> dbscan(T[] data, RNNSearch<T, T> nns, int minPts, double radius) {
        return (DBSCAN)package$time$.MODULE$.apply("DBSCAN", (Function0 & Serializable)() -> DBSCAN.fit((Object[])data, (RNNSearch)nns, (int)minPts, (double)radius));
    }

    public <T> DBSCAN<T> dbscan(T[] data, Distance<T> distance, int minPts, double radius) {
        return (DBSCAN)package$time$.MODULE$.apply("DBSCAN", (Function0 & Serializable)() -> DBSCAN.fit((Object[])data, (Distance)distance, (int)minPts, (double)radius));
    }

    public DBSCAN<double[]> dbscan(double[][] data, int minPts, double radius) {
        return (DBSCAN)package$time$.MODULE$.apply("DBSCAN", (Function0 & Serializable)() -> MODULE$.dbscan((T[])((Object[])data), (Distance)new EuclideanDistance(), minPts, radius));
    }

    public DENCLUE denclue(double[][] data, double sigma, int m) {
        return (DENCLUE)package$time$.MODULE$.apply("DENCLUE", (Function0 & Serializable)() -> DENCLUE.fit((double[][])data, (double)sigma, (int)m));
    }

    public <T> MEC<T> mec(T[] data, Distance<T> distance, int k, double radius) {
        return (MEC)package$time$.MODULE$.apply("MEC", (Function0 & Serializable)() -> MEC.fit((Object[])data, (Distance)distance, (int)k, (double)radius));
    }

    public <T> MEC<T> mec(T[] data, Metric<T> distance, int k, double radius) {
        return (MEC)package$time$.MODULE$.apply("MEC", (Function0 & Serializable)() -> MEC.fit((Object[])data, (Distance)distance, (int)k, (double)radius));
    }

    public MEC<double[]> mec(double[][] data, int k, double radius) {
        return (MEC)package$time$.MODULE$.apply("MEC", (Function0 & Serializable)() -> MEC.fit((Object[])((Object[])data), (Distance)new EuclideanDistance(), (int)k, (double)radius));
    }

    public <T> MEC<T> mec(T[] data, RNNSearch<T, T> nns, int k, double radius, int[] y, double tol) {
        return (MEC)package$time$.MODULE$.apply("MEC", (Function0 & Serializable)() -> MEC.fit((Object[])data, (RNNSearch)nns, (int)k, (double)radius, (int[])y, (double)tol));
    }

    public <T> double mec$default$6() {
        return 1.0E-4;
    }

    public SpectralClustering specc(DenseMatrix W, int k) {
        return (SpectralClustering)package$time$.MODULE$.apply("Spectral clustering", (Function0 & Serializable)() -> SpectralClustering.fit((DenseMatrix)W, (int)k));
    }

    public SpectralClustering specc(double[][] data, int k, double sigma) {
        return (SpectralClustering)package$time$.MODULE$.apply("Spectral clustering", (Function0 & Serializable)() -> SpectralClustering.fit((double[][])data, (int)k, (double)sigma));
    }

    public SpectralClustering specc(double[][] data, int k, int l, double sigma) {
        return (SpectralClustering)package$time$.MODULE$.apply("Spectral clustering", (Function0 & Serializable)() -> SpectralClustering.fit((double[][])data, (int)k, (int)l, (double)sigma));
    }

    public static final /* synthetic */ HierarchicalClustering $anonfun$hclust$1(Linkage linkage$1) {
        return HierarchicalClustering.fit((Linkage)linkage$1);
    }

    private package$() {
    }
}

