/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import smile.classification.Classifier;
import smile.clustering.HierarchicalClustering;
import smile.data.DataFrame;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;
import smile.plot.BoxPlot;
import smile.plot.Contour;
import smile.plot.Dendrogram;
import smile.plot.Grid;
import smile.plot.Heatmap;
import smile.plot.Hexmap;
import smile.plot.Histogram;
import smile.plot.Histogram3D;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.Palette;
import smile.plot.Plot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.plot.ScatterPlot;
import smile.plot.SparseMatrixPlot;
import smile.plot.StaircasePlot;
import smile.plot.Surface;
import smile.plot.Wireframe;
import smile.plot.swing.Window;
import smile.plot.swing.Window$;
import smile.projection.PCA;
import smile.regression.Regression;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.Distribution;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public Window plot(double[][] data, char legend, Color color) {
        PlotCanvas canvas = ScatterPlot.plot((double[][])data, (char)legend, (Color)color);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window plot(double[][] data, String[] labels) {
        PlotCanvas canvas = ScatterPlot.plot((double[][])data, (String[])labels);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window plot(double[][] data, int[] label, char legend, Color[] palette) {
        PlotCanvas canvas = ScatterPlot.plot((double[][])data, (int[])label, (char)legend, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window plot(double[][] data, int[] label, char[] legend, Color[] palette) {
        PlotCanvas canvas = ScatterPlot.plot((double[][])data, (int[])label, (char[])legend, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public JFrame plot(DataFrame data, char legend) {
        double[][] x = data.toArray();
        int p = data.ncols();
        String[] names = data.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$2(x, i, legend, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        JFrame frame = Window$.MODULE$.frame(Window$.MODULE$.frame$default$1());
        frame.add(panel);
        return frame;
    }

    public JFrame plot(DataFrame data, String category, char legend, Color[] palette) {
        DataFrame dat = data.drop(new String[]{category});
        double[][] x = dat.toArray();
        int[] y = data.column(category).toIntArray();
        int p = x[0].length;
        String[] names = dat.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$5(x, i, y, legend, palette, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        JFrame frame = Window$.MODULE$.frame(Window$.MODULE$.frame$default$1());
        frame.add(panel);
        return frame;
    }

    public JFrame plot(DataFrame data, String category, char[] legend, Color[] palette) {
        DataFrame dat = data.drop(new String[]{category});
        double[][] x = dat.toArray();
        int[] y = data.column(category).toIntArray();
        int p = x[0].length;
        String[] names = dat.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$8(x, i, y, legend, palette, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        JFrame frame = Window$.MODULE$.frame(Window$.MODULE$.frame$default$1());
        frame.add(panel);
        return frame;
    }

    public Window line(double[][] data, Line.Style style, Color color, char legend) {
        PlotCanvas canvas;
        block0: {
            canvas = LinePlot.plot((double[][])data, (Line.Style)style, (Color)color);
            if (legend == ' ') break block0;
            ScatterPlot scatter = new ScatterPlot(data, legend);
            scatter.setColor(color);
            canvas.add((Plot)scatter);
        }
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Line.Style line$default$2() {
        return Line.Style.SOLID;
    }

    public Color line$default$3() {
        return Color.BLACK;
    }

    public char line$default$4() {
        return ' ';
    }

    public Window staircase(Seq<double[]> data) {
        PlotCanvas canvas = StaircasePlot.plot((double[][])((double[][])data.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window boxplot(Seq<double[]> data) {
        PlotCanvas canvas = BoxPlot.plot((double[][])((double[][])data.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window boxplot(double[][] data, String[] labels) {
        PlotCanvas canvas = BoxPlot.plot((double[][])data, (String[])labels);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window contour(double[][] z) {
        PlotCanvas canvas = Contour.plot((double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window contour(double[][] z, double[] levels, Color[] palette) {
        PlotCanvas canvas = Contour.plot((double[][])z, (double[])levels, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window contour(double[] x, double[] y, double[][] z) {
        PlotCanvas canvas = Contour.plot((double[])x, (double[])y, (double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window contour(double[] x, double[] y, double[][] z, double[] levels, Color[] palette) {
        PlotCanvas canvas = Contour.plot((double[])x, (double[])y, (double[][])z, (double[])levels, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window surface(double[][] z) {
        PlotCanvas canvas = Surface.plot((double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window surface(double[][] z, Color[] palette) {
        PlotCanvas canvas = Surface.plot((double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window surface(double[] x, double[] y, double[][] z) {
        PlotCanvas canvas = Surface.plot((double[])x, (double[])y, (double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window surface(double[] x, double[] y, double[][] z, Color[] palette) {
        PlotCanvas canvas = Surface.plot((double[])x, (double[])y, (double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window wireframe(double[][] vertices, int[][] edges) {
        PlotCanvas canvas = Wireframe.plot((double[][])vertices, (int[][])edges);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window grid(double[][][] data) {
        PlotCanvas canvas = Grid.plot((double[][][])data);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(double[][] z) {
        PlotCanvas canvas = Heatmap.plot((double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(double[][] z, Color[] palette) {
        PlotCanvas canvas = Heatmap.plot((double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(double[] x, double[] y, double[][] z) {
        PlotCanvas canvas = Heatmap.plot((double[])x, (double[])y, (double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(double[] x, double[] y, double[][] z, Color[] palette) {
        PlotCanvas canvas = Heatmap.plot((double[])x, (double[])y, (double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(String[] rowLabels, String[] columnLabels, double[][] z) {
        PlotCanvas canvas = Heatmap.plot((String[])rowLabels, (String[])columnLabels, (double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window heatmap(String[] rowLabels, String[] columnLabels, double[][] z, Color[] palette) {
        PlotCanvas canvas = Heatmap.plot((String[])rowLabels, (String[])columnLabels, (double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window spy(SparseMatrix matrix2) {
        PlotCanvas canvas = SparseMatrixPlot.plot((SparseMatrix)matrix2);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hexmap(double[][] z) {
        PlotCanvas canvas = Heatmap.plot((double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hexmap(double[][] z, Color[] palette) {
        PlotCanvas canvas = Hexmap.plot((double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hexmap(String[][] labels, double[][] z) {
        PlotCanvas canvas = Hexmap.plot((String[][])labels, (double[][])z);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hexmap(String[][] labels, double[][] z, Color[] palette) {
        PlotCanvas canvas = Hexmap.plot((String[][])labels, (double[][])z, (Color[])palette);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[] data) {
        PlotCanvas canvas = Histogram.plot((double[])data);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[] data, int k) {
        PlotCanvas canvas = Histogram.plot((double[])data, (int)k);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[] data, double[] breaks) {
        PlotCanvas canvas = Histogram.plot((double[])data, (double[])breaks);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[][] data) {
        PlotCanvas canvas = Histogram3D.plot((double[][])data);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[][] data, int k) {
        PlotCanvas canvas = Histogram3D.plot((double[][])data, (int)k);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window hist(double[][] data, int xbins, int ybins) {
        PlotCanvas canvas = Histogram3D.plot((double[][])data, (int)xbins, (int)ybins);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window qqplot(double[] x) {
        PlotCanvas canvas = QQPlot.plot((double[])x);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window qqplot(double[] x, Distribution d) {
        PlotCanvas canvas = QQPlot.plot((double[])x, (Distribution)d);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window qqplot(double[] x, double[] y) {
        PlotCanvas canvas = QQPlot.plot((double[])x, (double[])y);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window qqplot(int[] x, DiscreteDistribution d) {
        PlotCanvas canvas = QQPlot.plot((int[])x, (DiscreteDistribution)d);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window qqplot(int[] x, int[] y) {
        PlotCanvas canvas = QQPlot.plot((int[])x, (int[])y);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window plot(double[][] x, int[] y, Classifier<double[]> model) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(x[0])) == 2, (Function0 & Serializable)() -> "plot of classification model supports only 2-dimensional data");
        Window win = this.plot(x, y, 'o', Palette.COLORS);
        double[] lower = win.canvas().getLowerBounds();
        double[] upper = win.canvas().getUpperBounds();
        int steps = 50;
        double step1 = (upper[0] - lower[0]) / (double)steps;
        double[] v1 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$1 -> lower[0] + step1 * (double)x$1).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double step2 = (upper[1] - lower[1]) / (double)steps;
        double[] v2 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$2 -> lower[1] + step2 * (double)x$2).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double[][] z = (double[][])Array$.MODULE$.ofDim(v1.length, v2.length, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[] p = new double[]{v1[i], v2[j]};
            int c = model.predict((Object)p);
            z$1[j][i$4] = c;
            win.canvas().point('.', Palette.COLORS[c], p);
        }));
        double[] levels = (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MathEx.max((int[])y)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$3 -> (double)x$3 + 0.5).toArray((ClassTag)ClassTag$.MODULE$.Double());
        Contour contour = new Contour(v1, v2, z, levels);
        contour.showLevelValue(false);
        win.canvas().add((Plot)contour);
        return win;
    }

    public Window plot(double[][] x, double[] y, Regression<double[]> model) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(x[0])) == 2, (Function0 & Serializable)() -> "plot of regression model supports only 2-dimensional data");
        double[][] points = (double[][])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])x), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(y))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] x = (double[])tuple2._1();
            double y = tuple2._2$mcD$sp();
            double[] dArray = new double[]{x[0], x[1], y};
            return dArray;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Window win = this.plot(points, 'o', this.plot$default$3());
        double[] lower = win.canvas().getLowerBounds();
        double[] upper = win.canvas().getUpperBounds();
        int steps = 50;
        double step1 = (upper[0] - lower[0]) / (double)steps;
        double[] v1 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$4 -> lower[0] + step1 * (double)x$4).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double step2 = (upper[1] - lower[1]) / (double)steps;
        double[] v2 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$5 -> lower[1] + step2 * (double)x$5).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double[][] z = (double[][])Array$.MODULE$.ofDim(v1.length, v2.length, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[] p = new double[]{v1[i], v2[j]};
            z$2[j][i$5] = model.predict((Object)p);
        }));
        Surface surface = new Surface(v1, v2, z, Palette.jet((int)256));
        win.canvas().add((Plot)surface);
        return win;
    }

    public char plot$default$2() {
        return '*';
    }

    public Color plot$default$3() {
        return Color.BLACK;
    }

    public Window screeplot(PCA pca) {
        PlotCanvas canvas = PlotCanvas.screeplot((PCA)pca);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window dendrogram(HierarchicalClustering hc) {
        PlotCanvas canvas = Dendrogram.plot((String)"Dendrogram", (int[][])hc.getTree(), (double[])hc.getHeight());
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public Window dendrogram(int[][] merge, double[] height) {
        PlotCanvas canvas = Dendrogram.plot((int[][])merge, (double[])height);
        return Window$.MODULE$.apply(canvas, Window$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ Component $anonfun$plot$2(double[][] x$6, int i$1, char legend$1, String[] names$1, JPanel panel$1, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$6), (Function1 & Serializable)row -> new double[]{row[i$1], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (char)legend$1);
        canvas.setAxisLabels(new String[]{names$1[i$1], names$1[j]});
        return panel$1.add((Component)canvas);
    }

    public static final /* synthetic */ Component $anonfun$plot$5(double[][] x$7, int i$2, int[] y$1, char legend$2, Color[] palette$1, String[] names$2, JPanel panel$2, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$7), (Function1 & Serializable)row -> new double[]{row[i$2], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (int[])y$1, (char)legend$2, (Color[])palette$1);
        canvas.setAxisLabels(new String[]{names$2[i$2], names$2[j]});
        return panel$2.add((Component)canvas);
    }

    public static final /* synthetic */ Component $anonfun$plot$8(double[][] x$8, int i$3, int[] y$2, char[] legend$3, Color[] palette$2, String[] names$3, JPanel panel$3, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$8), (Function1 & Serializable)row -> new double[]{row[i$3], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (int[])y$2, (char[])legend$3, (Color[])palette$2);
        canvas.setAxisLabels(new String[]{names$3[i$3], names$3[j]});
        return panel$3.add((Component)canvas);
    }

    private package$() {
    }
}

