/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.io.Serializable;
import java.util.stream.LongStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import smile.base.cart.SplitRule;
import smile.base.mlp.LayerBuilder;
import smile.base.rbf.RBF;
import smile.classification.AdaBoost;
import smile.classification.ClassLabels;
import smile.classification.Classifier;
import smile.classification.DecisionTree;
import smile.classification.DiscreteNaiveBayes;
import smile.classification.FLD;
import smile.classification.GradientTreeBoost;
import smile.classification.KNN;
import smile.classification.LDA;
import smile.classification.LogisticRegression;
import smile.classification.MLP;
import smile.classification.Maxent;
import smile.classification.NaiveBayes;
import smile.classification.OneVersusOne;
import smile.classification.OneVersusRest;
import smile.classification.QDA;
import smile.classification.RBFNetwork;
import smile.classification.RDA;
import smile.classification.RandomForest;
import smile.classification.SVM;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.math.kernel.MercerKernel;
import smile.neighbor.KNNSearch;
import smile.stat.distribution.Distribution;
import smile.util.IntSet;
import smile.util.package$time$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public <T> KNN<T> knn(KNNSearch<T, T> x, int[] y, int k) {
        return new KNN(x, y, k);
    }

    public <T> KNN<T> knn(T[] x, int[] y, Distance<T> distance, int k) {
        return (KNN)package$time$.MODULE$.apply("K-Nearest Neighbor", (Function0 & Serializable)() -> KNN.fit((Object[])x, (int[])y, (Distance)distance, (int)k));
    }

    public KNN<double[]> knn(double[][] x, int[] y, int k) {
        return (KNN)package$time$.MODULE$.apply("K-Nearnest Neighbor", (Function0 & Serializable)() -> KNN.fit((double[][])x, (int[])y, (int)k));
    }

    public LogisticRegression logit(double[][] x, int[] y, double lambda, double tol, int maxIter) {
        return (LogisticRegression)package$time$.MODULE$.apply("Logistic Regression", (Function0 & Serializable)() -> LogisticRegression.fit((double[][])x, (int[])y, (double)lambda, (double)tol, (int)maxIter));
    }

    public double logit$default$3() {
        return 0.0;
    }

    public double logit$default$4() {
        return 1.0E-5;
    }

    public int logit$default$5() {
        return 500;
    }

    public Maxent maxent(int[][] x, int[] y, int p, double lambda, double tol, int maxIter) {
        return (Maxent)package$time$.MODULE$.apply("Maximum Entropy Model", (Function0 & Serializable)() -> Maxent.fit((int)p, (int[][])x, (int[])y, (double)lambda, (double)tol, (int)maxIter));
    }

    public double maxent$default$4() {
        return 0.1;
    }

    public double maxent$default$5() {
        return 1.0E-5;
    }

    public int maxent$default$6() {
        return 500;
    }

    public MLP mlp(double[][] x, int[] y, int p, LayerBuilder[] builders, int epochs, double eta, double alpha, double lambda) {
        return (MLP)package$time$.MODULE$.apply("Multi-layer Perceptron Neural Network", (Function0 & Serializable)() -> {
            MLP mlp = new MLP(p, builders);
            mlp.setLearningRate(eta);
            mlp.setMomentum(alpha);
            mlp.setWeightDecay(lambda);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), epochs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> mlp.update(x, y));
            return mlp;
        });
    }

    public int mlp$default$5() {
        return 10;
    }

    public double mlp$default$6() {
        return 0.1;
    }

    public double mlp$default$7() {
        return 0.0;
    }

    public double mlp$default$8() {
        return 0.0;
    }

    public <T> RBFNetwork<T> rbfnet(T[] x, int[] y, RBF<T>[] neurons, boolean normalized) {
        return (RBFNetwork)package$time$.MODULE$.apply("RBF Network", (Function0 & Serializable)() -> RBFNetwork.fit((Object[])x, (int[])y, (RBF[])neurons, (boolean)normalized));
    }

    public RBFNetwork<double[]> rbfnet(double[][] x, int[] y, int k, boolean normalized) {
        return (RBFNetwork)package$time$.MODULE$.apply("RBF Network", (Function0 & Serializable)() -> {
            RBF[] neurons = RBF.fit((double[][])x, (int)k);
            return RBFNetwork.fit((Object[])((Object[])x), (int[])y, (RBF[])neurons, (boolean)normalized);
        });
    }

    public boolean rbfnet$default$4() {
        return false;
    }

    public <T> SVM<T> svm(T[] x, int[] y, MercerKernel<T> kernel, double C, double tol) {
        return (SVM)package$time$.MODULE$.apply("SVM", (Function0 & Serializable)() -> SVM.fit((Object[])x, (int[])y, (MercerKernel)kernel, (double)C, (double)tol));
    }

    public <T> double svm$default$5() {
        return 0.001;
    }

    public DecisionTree cart(Formula formula, DataFrame data, SplitRule splitRule, int maxDepth, int maxNodes, int nodeSize) {
        return (DecisionTree)package$time$.MODULE$.apply("Decision Tree", (Function0 & Serializable)() -> DecisionTree.fit((Formula)formula, (DataFrame)data, (SplitRule)splitRule, (int)maxDepth, (int)(maxNodes > 0 ? maxNodes : data.size() / nodeSize), (int)nodeSize));
    }

    public SplitRule cart$default$3() {
        return SplitRule.GINI;
    }

    public int cart$default$4() {
        return 20;
    }

    public int cart$default$5() {
        return 0;
    }

    public int cart$default$6() {
        return 5;
    }

    public RandomForest randomForest(Formula formula, DataFrame data, int ntrees, int mtry, SplitRule splitRule, int maxDepth, int maxNodes, int nodeSize, double subsample, int[] classWeight, LongStream seeds) {
        return (RandomForest)package$time$.MODULE$.apply("Random Forest", (Function0 & Serializable)() -> RandomForest.fit((Formula)formula, (DataFrame)data, (int)ntrees, (int)mtry, (SplitRule)splitRule, (int)maxDepth, (int)maxNodes, (int)nodeSize, (double)subsample, (int[])classWeight, (LongStream)seeds));
    }

    public int randomForest$default$3() {
        return 500;
    }

    public int randomForest$default$4() {
        return 0;
    }

    public SplitRule randomForest$default$5() {
        return SplitRule.GINI;
    }

    public int randomForest$default$6() {
        return 20;
    }

    public int randomForest$default$7() {
        return 500;
    }

    public int randomForest$default$8() {
        return 1;
    }

    public double randomForest$default$9() {
        return 1.0;
    }

    public int[] randomForest$default$10() {
        return null;
    }

    public LongStream randomForest$default$11() {
        return null;
    }

    public GradientTreeBoost gbm(Formula formula, DataFrame data, int ntrees, int maxDepth, int maxNodes, int nodeSize, double shrinkage, double subsample) {
        return (GradientTreeBoost)package$time$.MODULE$.apply("Gradient Tree Boosting", (Function0 & Serializable)() -> GradientTreeBoost.fit((Formula)formula, (DataFrame)data, (int)ntrees, (int)maxDepth, (int)maxNodes, (int)nodeSize, (double)shrinkage, (double)subsample));
    }

    public int gbm$default$3() {
        return 500;
    }

    public int gbm$default$4() {
        return 20;
    }

    public int gbm$default$5() {
        return 6;
    }

    public int gbm$default$6() {
        return 5;
    }

    public double gbm$default$7() {
        return 0.05;
    }

    public double gbm$default$8() {
        return 0.7;
    }

    public AdaBoost adaboost(Formula formula, DataFrame data, int ntrees, int maxDepth, int maxNodes, int nodeSize) {
        return (AdaBoost)package$time$.MODULE$.apply("AdaBoost", (Function0 & Serializable)() -> AdaBoost.fit((Formula)formula, (DataFrame)data, (int)ntrees, (int)maxDepth, (int)maxNodes, (int)nodeSize));
    }

    public int adaboost$default$3() {
        return 500;
    }

    public int adaboost$default$4() {
        return 20;
    }

    public int adaboost$default$5() {
        return 6;
    }

    public int adaboost$default$6() {
        return 1;
    }

    public FLD fisher(double[][] x, int[] y, int L, double tol) {
        return (FLD)package$time$.MODULE$.apply("Fisher's Linear Discriminant", (Function0 & Serializable)() -> FLD.fit((double[][])x, (int[])y, (int)L, (double)tol));
    }

    public int fisher$default$3() {
        return -1;
    }

    public double fisher$default$4() {
        return 1.0E-4;
    }

    public LDA lda(double[][] x, int[] y, double[] priori, double tol) {
        return (LDA)package$time$.MODULE$.apply("Linear Discriminant Analysis", (Function0 & Serializable)() -> LDA.fit((double[][])x, (int[])y, (double[])priori, (double)tol));
    }

    public double[] lda$default$3() {
        return null;
    }

    public double lda$default$4() {
        return 1.0E-4;
    }

    public QDA qda(double[][] x, int[] y, double[] priori, double tol) {
        return (QDA)package$time$.MODULE$.apply("Quadratic Discriminant Analysis", (Function0 & Serializable)() -> QDA.fit((double[][])x, (int[])y, (double[])priori, (double)tol));
    }

    public double[] qda$default$3() {
        return null;
    }

    public double qda$default$4() {
        return 1.0E-4;
    }

    public RDA rda(double[][] x, int[] y, double alpha, double[] priori, double tol) {
        return (RDA)package$time$.MODULE$.apply("Regularized Discriminant Analysis", (Function0 & Serializable)() -> RDA.fit((double[][])x, (int[])y, (double)alpha, (double[])priori, (double)tol));
    }

    public double[] rda$default$4() {
        return null;
    }

    public double rda$default$5() {
        return 1.0E-4;
    }

    public DiscreteNaiveBayes naiveBayes(int[][] x, int[] y, DiscreteNaiveBayes.Model model, double[] priori, double sigma) {
        return (DiscreteNaiveBayes)package$time$.MODULE$.apply("Naive Bayes", (Function0 & Serializable)() -> {
            int p = x[0].length;
            int k = MathEx.max((int[])y) + 1;
            IntSet labels = ClassLabels.fit((int[])y$13).labels;
            DiscreteNaiveBayes naive = priori == null ? new DiscreteNaiveBayes(model, k, p, sigma, labels) : new DiscreteNaiveBayes(model, priori, p, sigma, labels);
            naive.update(x, y);
            return naive;
        });
    }

    public NaiveBayes naiveBayes(double[] priori, Distribution[][] condprob) {
        return new NaiveBayes(priori, condprob);
    }

    public double[] naiveBayes$default$4() {
        return null;
    }

    public double naiveBayes$default$5() {
        return 1.0;
    }

    public <T> OneVersusOne<T> ovo(T[] x, int[] y, Function2<T[], int[], Classifier<T>> trainer) {
        return (OneVersusOne)package$time$.MODULE$.apply("One vs. One", (Function0 & Serializable)() -> OneVersusOne.fit((Object[])x, (int[])y, smile.util.package$.MODULE$.toJavaBiFunction(trainer)));
    }

    public <T> OneVersusRest<T> ovr(T[] x, int[] y, Function2<T[], int[], Classifier<T>> trainer) {
        return (OneVersusRest)package$time$.MODULE$.apply("One vs. Rest", (Function0 & Serializable)() -> OneVersusRest.fit((Object[])x, (int[])y, smile.util.package$.MODULE$.toJavaBiFunction(trainer)));
    }

    private package$() {
    }
}

