/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import smile.classification.Classifier;
import smile.clustering.HierarchicalClustering;
import smile.data.DataFrame;
import smile.math.MathEx;
import smile.math.matrix.SparseMatrix;
import smile.plot.swing.BoxPlot;
import smile.plot.swing.Contour;
import smile.plot.swing.Dendrogram;
import smile.plot.swing.Grid;
import smile.plot.swing.Headless;
import smile.plot.swing.Heatmap;
import smile.plot.swing.Hexmap;
import smile.plot.swing.Histogram;
import smile.plot.swing.Histogram3D;
import smile.plot.swing.Line;
import smile.plot.swing.LinePlot;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;
import smile.plot.swing.PlotCanvas;
import smile.plot.swing.QQPlot;
import smile.plot.swing.ScatterPlot;
import smile.plot.swing.SparseMatrixPlot;
import smile.plot.swing.StaircasePlot;
import smile.plot.swing.Surface;
import smile.plot.swing.Wireframe;
import smile.projection.PCA;
import smile.regression.Regression;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.Distribution;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public String img(JComponent canvas) {
        Headless headless = new Headless(canvas);
        headless.pack();
        headless.setVisible(true);
        SwingUtilities.invokeAndWait(() -> {});
        BufferedImage bi = new BufferedImage(canvas.getWidth(), canvas.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        canvas.print(g2d);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "png", os);
        String base64 = Base64.getEncoder().encodeToString(os.toByteArray());
        return new StringBuilder(34).append("<img src=\"data:image/png;base64,").append(base64).append("\">").toString();
    }

    public PlotCanvas plot(double[][] data, char legend, Color color) {
        return ScatterPlot.plot((double[][])data, (char)legend, (Color)color);
    }

    public PlotCanvas plot(double[][] data, String[] labels) {
        return ScatterPlot.plot((double[][])data, (String[])labels);
    }

    public PlotCanvas plot(double[][] data, int[] label, char legend, Color[] palette) {
        return ScatterPlot.plot((double[][])data, (int[])label, (char)legend, (Color[])palette);
    }

    public PlotCanvas plot(double[][] data, int[] label, char[] legend, Color[] palette) {
        return ScatterPlot.plot((double[][])data, (int[])label, (char[])legend, (Color[])palette);
    }

    public JPanel plot(DataFrame data, char legend) {
        double[][] x = data.toArray();
        int p = data.ncols();
        String[] names = data.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$2(x, i, legend, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        return panel;
    }

    public JPanel plot(DataFrame data, String category, char legend, Color[] palette) {
        DataFrame dat = data.drop(new String[]{category});
        double[][] x = dat.toArray();
        int[] y = data.column(category).toIntArray();
        int p = x[0].length;
        String[] names = dat.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$5(x, i, y, legend, palette, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        return panel;
    }

    public JPanel plot(DataFrame data, String category, char[] legend, Color[] palette) {
        DataFrame dat = data.drop(new String[]{category});
        double[][] x = dat.toArray();
        int[] y = data.column(category).toIntArray();
        int p = x[0].length;
        String[] names = dat.names();
        JPanel panel = new JPanel(new GridLayout(p, p));
        panel.setBackground(Color.white);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), p).foreach((Function1 & Serializable)j -> package$.$anonfun$plot$8(x, i, y, legend, palette, names, panel, BoxesRunTime.unboxToInt((Object)j))));
        return panel;
    }

    public PlotCanvas line(double[][] data, Line.Style style, Color color, char legend) {
        PlotCanvas canvas;
        block0: {
            canvas = LinePlot.plot((double[][])data, (Line.Style)style, (Color)color);
            if (legend == ' ') break block0;
            ScatterPlot scatter = new ScatterPlot(data, legend);
            scatter.setColor(color);
            canvas.add((Plot)scatter);
        }
        return canvas;
    }

    public Line.Style line$default$2() {
        return Line.Style.SOLID;
    }

    public Color line$default$3() {
        return Color.BLACK;
    }

    public char line$default$4() {
        return ' ';
    }

    public PlotCanvas staircase(Seq<double[]> data) {
        return StaircasePlot.plot((double[][])((double[][])data.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }

    public PlotCanvas boxplot(Seq<double[]> data) {
        return BoxPlot.plot((double[][])((double[][])data.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }

    public PlotCanvas boxplot(double[][] data, String[] labels) {
        return BoxPlot.plot((double[][])data, (String[])labels);
    }

    public PlotCanvas contour(double[][] z) {
        return Contour.plot((double[][])z);
    }

    public PlotCanvas contour(double[][] z, double[] levels, Color[] palette) {
        return Contour.plot((double[][])z, (double[])levels, (Color[])palette);
    }

    public PlotCanvas contour(double[] x, double[] y, double[][] z) {
        return Contour.plot((double[])x, (double[])y, (double[][])z);
    }

    public PlotCanvas contour(double[] x, double[] y, double[][] z, double[] levels, Color[] palette) {
        return Contour.plot((double[])x, (double[])y, (double[][])z, (double[])levels, (Color[])palette);
    }

    public PlotCanvas surface(double[][] z) {
        return Surface.plot((double[][])z);
    }

    public PlotCanvas surface(double[][] z, Color[] palette) {
        return Surface.plot((double[][])z, (Color[])palette);
    }

    public PlotCanvas surface(double[] x, double[] y, double[][] z) {
        return Surface.plot((double[])x, (double[])y, (double[][])z);
    }

    public PlotCanvas surface(double[] x, double[] y, double[][] z, Color[] palette) {
        return Surface.plot((double[])x, (double[])y, (double[][])z, (Color[])palette);
    }

    public PlotCanvas wireframe(double[][] vertices, int[][] edges) {
        return Wireframe.plot((double[][])vertices, (int[][])edges);
    }

    public PlotCanvas grid(double[][][] data) {
        return Grid.plot((double[][][])data);
    }

    public PlotCanvas heatmap(double[][] z) {
        return Heatmap.plot((double[][])z);
    }

    public PlotCanvas heatmap(double[][] z, Color[] palette) {
        return Heatmap.plot((double[][])z, (Color[])palette);
    }

    public PlotCanvas heatmap(double[] x, double[] y, double[][] z) {
        return Heatmap.plot((double[])x, (double[])y, (double[][])z);
    }

    public PlotCanvas heatmap(double[] x, double[] y, double[][] z, Color[] palette) {
        return Heatmap.plot((double[])x, (double[])y, (double[][])z, (Color[])palette);
    }

    public PlotCanvas heatmap(String[] rowLabels, String[] columnLabels, double[][] z) {
        return Heatmap.plot((String[])rowLabels, (String[])columnLabels, (double[][])z);
    }

    public PlotCanvas heatmap(String[] rowLabels, String[] columnLabels, double[][] z, Color[] palette) {
        return Heatmap.plot((String[])rowLabels, (String[])columnLabels, (double[][])z, (Color[])palette);
    }

    public PlotCanvas spy(SparseMatrix matrix2) {
        return SparseMatrixPlot.plot((SparseMatrix)matrix2);
    }

    public PlotCanvas hexmap(double[][] z) {
        return Heatmap.plot((double[][])z);
    }

    public PlotCanvas hexmap(double[][] z, Color[] palette) {
        return Hexmap.plot((double[][])z, (Color[])palette);
    }

    public PlotCanvas hexmap(String[][] labels, double[][] z) {
        return Hexmap.plot((String[][])labels, (double[][])z);
    }

    public PlotCanvas hexmap(String[][] labels, double[][] z, Color[] palette) {
        return Hexmap.plot((String[][])labels, (double[][])z, (Color[])palette);
    }

    public PlotCanvas hist(double[] data) {
        return Histogram.plot((double[])data);
    }

    public PlotCanvas hist(double[] data, int k) {
        return Histogram.plot((double[])data, (int)k);
    }

    public PlotCanvas hist(double[] data, double[] breaks) {
        return Histogram.plot((double[])data, (double[])breaks);
    }

    public PlotCanvas hist(double[][] data) {
        return Histogram3D.plot((double[][])data);
    }

    public PlotCanvas hist(double[][] data, int k) {
        return Histogram3D.plot((double[][])data, (int)k);
    }

    public PlotCanvas hist(double[][] data, int xbins, int ybins) {
        return Histogram3D.plot((double[][])data, (int)xbins, (int)ybins);
    }

    public PlotCanvas qqplot(double[] x) {
        return QQPlot.plot((double[])x);
    }

    public PlotCanvas qqplot(double[] x, Distribution d) {
        return QQPlot.plot((double[])x, (Distribution)d);
    }

    public PlotCanvas qqplot(double[] x, double[] y) {
        return QQPlot.plot((double[])x, (double[])y);
    }

    public PlotCanvas qqplot(int[] x, DiscreteDistribution d) {
        return QQPlot.plot((int[])x, (DiscreteDistribution)d);
    }

    public PlotCanvas qqplot(int[] x, int[] y) {
        return QQPlot.plot((int[])x, (int[])y);
    }

    public PlotCanvas plot(double[][] x, int[] y, Classifier<double[]> model) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(x[0])) == 2, (Function0 & Serializable)() -> "plot of classification model supports only 2-dimensional data");
        PlotCanvas canvas = this.plot(x, y, 'o', Palette.COLORS);
        double[] lower = canvas.getLowerBounds();
        double[] upper = canvas.getUpperBounds();
        int steps = 50;
        double step1 = (upper[0] - lower[0]) / (double)steps;
        double[] v1 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$1 -> lower[0] + step1 * (double)x$1).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double step2 = (upper[1] - lower[1]) / (double)steps;
        double[] v2 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$2 -> lower[1] + step2 * (double)x$2).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double[][] z = (double[][])Array$.MODULE$.ofDim(v1.length, v2.length, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[] p = new double[]{v1[i], v2[j]};
            int c = model.predict((Object)p);
            z$1[j][i$4] = c;
            canvas.point('.', Palette.COLORS[c], p);
        }));
        double[] levels = (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MathEx.max((int[])y)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$3 -> (double)x$3 + 0.5).toArray((ClassTag)ClassTag$.MODULE$.Double());
        Contour contour = new Contour(v1, v2, z, levels);
        contour.showLevelValue(false);
        canvas.add((Plot)contour);
        return canvas;
    }

    public PlotCanvas plot(double[][] x, double[] y, Regression<double[]> model) {
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.doubleArrayOps(x[0])) == 2, (Function0 & Serializable)() -> "plot of regression model supports only 2-dimensional data");
        double[][] points = (double[][])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])x), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(y))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double[] x = (double[])tuple2._1();
            double y = tuple2._2$mcD$sp();
            double[] dArray = new double[]{x[0], x[1], y};
            return dArray;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = this.plot(points, 'o', this.plot$default$3());
        double[] lower = canvas.getLowerBounds();
        double[] upper = canvas.getUpperBounds();
        int steps = 50;
        double step1 = (upper[0] - lower[0]) / (double)steps;
        double[] v1 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$4 -> lower[0] + step1 * (double)x$4).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double step2 = (upper[1] - lower[1]) / (double)steps;
        double[] v2 = (double[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).map((Function1)(JFunction1.mcDI.sp & Serializable)x$5 -> lower[1] + step2 * (double)x$5).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double[][] z = (double[][])Array$.MODULE$.ofDim(v1.length, v2.length, (ClassTag)ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), steps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            double[] p = new double[]{v1[i], v2[j]};
            z$2[j][i$5] = model.predict((Object)p);
        }));
        Surface surface = new Surface(v1, v2, z, Palette.jet((int)256));
        canvas.add((Plot)surface);
        return canvas;
    }

    public char plot$default$2() {
        return '*';
    }

    public Color plot$default$3() {
        return Color.BLACK;
    }

    public PlotCanvas screeplot(PCA pca) {
        return PlotCanvas.screeplot((PCA)pca);
    }

    public PlotCanvas dendrogram(HierarchicalClustering hc) {
        return Dendrogram.plot((String)"Dendrogram", (int[][])hc.getTree(), (double[])hc.getHeight());
    }

    public PlotCanvas dendrogram(int[][] merge, double[] height) {
        return Dendrogram.plot((int[][])merge, (double[])height);
    }

    public static final /* synthetic */ Component $anonfun$plot$2(double[][] x$6, int i$1, char legend$1, String[] names$1, JPanel panel$1, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$6), (Function1 & Serializable)row -> new double[]{row[i$1], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (char)legend$1);
        canvas.setAxisLabels(new String[]{names$1[i$1], names$1[j]});
        return panel$1.add((Component)canvas);
    }

    public static final /* synthetic */ Component $anonfun$plot$5(double[][] x$7, int i$2, int[] y$1, char legend$2, Color[] palette$1, String[] names$2, JPanel panel$2, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$7), (Function1 & Serializable)row -> new double[]{row[i$2], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (int[])y$1, (char)legend$2, (Color[])palette$1);
        canvas.setAxisLabels(new String[]{names$2[i$2], names$2[j]});
        return panel$2.add((Component)canvas);
    }

    public static final /* synthetic */ Component $anonfun$plot$8(double[][] x$8, int i$3, int[] y$2, char[] legend$3, Color[] palette$2, String[] names$3, JPanel panel$3, int j) {
        double[][] x2 = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$8), (Function1 & Serializable)row -> new double[]{row[i$3], row[j]}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        PlotCanvas canvas = ScatterPlot.plot((double[][])x2, (int[])y$2, (char[])legend$3, (Color[])palette$2);
        canvas.setAxisLabels(new String[]{names$3[i$3], names$3[j]});
        return panel$3.add((Component)canvas);
    }

    private package$() {
    }
}

