/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.classification.SoftClassifier;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.util.package$time$;
import smile.validation.AUC;
import smile.validation.Accuracy;
import smile.validation.AdjustedRandIndex;
import smile.validation.ClassificationMeasure;
import smile.validation.ConfusionMatrix;
import smile.validation.FDR;
import smile.validation.FMeasure;
import smile.validation.Fallout;
import smile.validation.MCC;
import smile.validation.MSE;
import smile.validation.MeanAbsoluteDeviation;
import smile.validation.NormalizedMutualInformation;
import smile.validation.Precision;
import smile.validation.RMSE;
import smile.validation.RSS;
import smile.validation.RandIndex;
import smile.validation.Recall;
import smile.validation.RegressionMeasure;
import smile.validation.Sensitivity;
import smile.validation.Specificity;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public ConfusionMatrix confusion(int[] truth, int[] prediction) {
        return ConfusionMatrix.of((int[])truth, (int[])prediction);
    }

    public double accuracy(int[] truth, int[] prediction) {
        return Accuracy.of((int[])truth, (int[])prediction);
    }

    public double recall(int[] truth, int[] prediction) {
        return Recall.of((int[])truth, (int[])prediction);
    }

    public double precision(int[] truth, int[] prediction) {
        return Precision.of((int[])truth, (int[])prediction);
    }

    public double sensitivity(int[] truth, int[] prediction) {
        return Sensitivity.of((int[])truth, (int[])prediction);
    }

    public double specificity(int[] truth, int[] prediction) {
        return Specificity.of((int[])truth, (int[])prediction);
    }

    public double fallout(int[] truth, int[] prediction) {
        return Fallout.of((int[])truth, (int[])prediction);
    }

    public double fdr(int[] truth, int[] prediction) {
        return FDR.of((int[])truth, (int[])prediction);
    }

    public double f1(int[] truth, int[] prediction) {
        return FMeasure.of((double)1.0, (int[])truth, (int[])prediction);
    }

    public double auc(int[] truth, double[] probability) {
        return AUC.of((int[])truth, (double[])probability);
    }

    public double mcc(int[] truth, int[] prediction) {
        return MCC.of((int[])truth, (int[])prediction);
    }

    public double mse(double[] truth, double[] prediction) {
        return MSE.of((double[])truth, (double[])prediction);
    }

    public double rmse(double[] truth, double[] prediction) {
        return RMSE.of((double[])truth, (double[])prediction);
    }

    public double rss(double[] truth, double[] prediction) {
        return RSS.of((double[])truth, (double[])prediction);
    }

    public double mad(double[] truth, double[] prediction) {
        return MeanAbsoluteDeviation.of((double[])truth, (double[])prediction);
    }

    public double randIndex(int[] y1, int[] y2) {
        return RandIndex.of((int[])y1, (int[])y2);
    }

    public double adjustedRandIndex(int[] y1, int[] y2) {
        return AdjustedRandIndex.of((int[])y1, (int[])y2);
    }

    public double nmi(int[] y1, int[] y2) {
        return NormalizedMutualInformation.max((int[])y1, (int[])y2);
    }

    public <T, C extends Classifier<T>> C test(Object x, int[] y, Object testx, int[] testy, Function2<Object, int[], C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        Classifier classifier = (Classifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (Classifier)trainer.apply(x, (Object)y));
        Predef$.MODULE$.println((Object)"testing...");
        int[] pred = (int[])package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(testx), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)classifier.predict(x$1)), (ClassTag)ClassTag$.MODULE$.Int()));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])pred)})));
        return (C)classifier;
    }

    public <C extends DataFrameClassifier> C test(Formula formula, DataFrame train, DataFrame test, Function2<Formula, DataFrame, C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        DataFrameClassifier classifier = (DataFrameClassifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (DataFrameClassifier)trainer.apply((Object)formula, (Object)train));
        Predef$.MODULE$.println((Object)"testing...");
        int[] pred = (int[])package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> classifier.predict(test));
        int[] testy = formula.y(test).toIntArray();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])pred)})));
        return (C)classifier;
    }

    public <T, C extends Classifier<T>> C test2(Object x, int[] y, Object testx, int[] testy, Function2<Object, int[], C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        Classifier classifier = (Classifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (Classifier)trainer.apply(x, (Object)y));
        Predef$.MODULE$.println((Object)"testing...");
        int[] pred = (int[])package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(testx), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)classifier.predict(x$2)), (ClassTag)ClassTag$.MODULE$.Int()));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Sensitivity/Recall = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Sensitivity.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Specificity = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Specificity.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Precision = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Precision.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F1-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)1.0, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F2-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)2.0, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F0.5-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)0.5, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])pred)})));
        return (C)classifier;
    }

    public <C extends DataFrameClassifier> C test2(Formula formula, DataFrame train, DataFrame test, Function2<Formula, DataFrame, C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        DataFrameClassifier classifier = (DataFrameClassifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (DataFrameClassifier)trainer.apply((Object)formula, (Object)train));
        Predef$.MODULE$.println((Object)"testing...");
        int[] pred = (int[])package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> classifier.predict(test));
        int[] testy = formula.y(test).toIntArray();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Sensitivity/Recall = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Sensitivity.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Specificity = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Specificity.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Precision = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Precision.of((int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F1-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)1.0, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F2-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)2.0, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F0.5-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)0.5, (int[])testy, (int[])pred)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])pred)})));
        return (C)classifier;
    }

    public <T, C extends SoftClassifier<T>> C test2soft(Object x, int[] y, Object testx, int[] testy, Function2<Object, int[], C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        SoftClassifier classifier = (SoftClassifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (SoftClassifier)trainer.apply(x, (Object)y));
        Predef$.MODULE$.println((Object)"testing...");
        Tuple2[] results = (Tuple2[])package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> {
            double[] posteriori = new double[]{0.0, 0.0};
            return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(testx), (Function1 & Serializable)xi -> {
                int yi = classifier.predict(xi, posteriori);
                return new Tuple2.mcID.sp(yi, posteriori[1]);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
        });
        Tuple2 tuple2 = ArrayOps$.MODULE$.unzip$extension(Predef$.MODULE$.refArrayOps((Object[])results), Predef$.MODULE$.$conforms(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Double());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] prediction = (int[])tuple2._1();
        double[] probability = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)prediction, (Object)probability);
        Tuple2 tuple23 = tuple22;
        int[] prediction2 = (int[])tuple23._1();
        double[] probability2 = (double[])tuple23._2();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Sensitivity/Recall = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Sensitivity.of((int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Specificity = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Specificity.of((int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Precision = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Precision.of((int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F1-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)1.0, (int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F2-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)2.0, (int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F0.5-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)0.5, (int[])testy, (int[])prediction2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("AUC = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * AUC.of((int[])testy, (double[])probability2)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])prediction2)})));
        return (C)classifier;
    }

    public <C extends SoftClassifier<Tuple>> C test2soft(Formula formula, DataFrame train, DataFrame test, Function2<Formula, DataFrame, C> trainer) {
        Predef$.MODULE$.println((Object)"training...");
        SoftClassifier classifier = (SoftClassifier)package$time$.MODULE$.apply("training", (Function0 & Serializable)() -> (SoftClassifier)trainer.apply((Object)formula, (Object)train));
        Predef$.MODULE$.println((Object)"testing...");
        IndexedSeq results = (IndexedSeq)package$time$.MODULE$.apply("testing", (Function0 & Serializable)() -> {
            double[] posteriori = new double[]{0.0, 0.0};
            return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), test.size()).map((Function1 & Serializable)i -> package$.$anonfun$test2soft$6(classifier, test, posteriori, BoxesRunTime.unboxToInt((Object)i)));
        });
        Tuple2 tuple2 = results.unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq pred = (IndexedSeq)tuple2._1();
        IndexedSeq prob = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pred, (Object)prob);
        Tuple2 tuple23 = tuple22;
        IndexedSeq pred2 = (IndexedSeq)tuple23._1();
        IndexedSeq prob2 = (IndexedSeq)tuple23._2();
        int[] prediction = (int[])pred2.toArray((ClassTag)ClassTag$.MODULE$.Int());
        double[] probability = (double[])prob2.toArray((ClassTag)ClassTag$.MODULE$.Double());
        int[] testy = formula.y(test).toIntArray();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accuracy = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Accuracy.of((int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Sensitivity/Recall = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Sensitivity.of((int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Specificity = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Specificity.of((int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Precision = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * Precision.of((int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F1-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)1.0, (int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F2-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)2.0, (int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("F0.5-Score = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * FMeasure.of((double)0.5, (int[])testy, (int[])prediction)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("AUC = %.2f%%"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * AUC.of((int[])testy, (double[])probability)))})));
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Confusion Matrix: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ConfusionMatrix.of((int[])testy, (int[])prediction)})));
        return (C)classifier;
    }

    public Seq<ClassificationMeasure> smile$validation$package$$measuresOrAccuracy(Seq<ClassificationMeasure> measures) {
        return measures.isEmpty() ? (Seq)new .colon.colon((Object)new Accuracy(), (List)Nil$.MODULE$) : measures;
    }

    public Seq<RegressionMeasure> smile$validation$package$$measuresOrRMSE(Seq<RegressionMeasure> measures) {
        return measures.isEmpty() ? (Seq)new .colon.colon((Object)new RMSE(), (List)Nil$.MODULE$) : measures;
    }

    public static final /* synthetic */ Tuple2 $anonfun$test2soft$6(SoftClassifier classifier$6, DataFrame test$3, double[] posteriori$2, int i) {
        int y = classifier$6.predict(test$3.apply(i), posteriori$2);
        return new Tuple2.mcID.sp(y, posteriori$2[1]);
    }

    private package$() {
    }
}

