/*
 * Decompiled with CFR 0.152.
 */
package com.github.hanleyt;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public class JerseyExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Collection<Class<?>> INJECTABLE_PARAMETER_TYPES = Arrays.asList(Client.class, WebTarget.class, URI.class);
    private final Function<ExtensionContext, TestContainerFactory> testContainerFactoryProvider;
    private final Function<ExtensionContext, DeploymentContext> deploymentContextProvider;
    private final BiFunction<ExtensionContext, ClientConfig, ClientConfig> configProvider;

    private JerseyExtension() {
        throw new IllegalStateException("JerseyExtension must be registered programmatically");
    }

    public JerseyExtension(Supplier<Application> applicationSupplier) {
        this((ExtensionContext unused) -> (Application)applicationSupplier.get(), null);
    }

    public JerseyExtension(Supplier<Application> applicationSupplier, BiFunction<ExtensionContext, ClientConfig, ClientConfig> configProvider) {
        this((ExtensionContext unused) -> (Application)applicationSupplier.get(), configProvider);
    }

    public JerseyExtension(Function<ExtensionContext, Application> applicationProvider) {
        this(applicationProvider, null);
    }

    public JerseyExtension(Function<ExtensionContext, Application> applicationProvider, BiFunction<ExtensionContext, ClientConfig, ClientConfig> configProvider) {
        this(null, context -> DeploymentContext.builder((Application)((Application)applicationProvider.apply((ExtensionContext)context))).build(), configProvider);
    }

    public JerseyExtension(Function<ExtensionContext, TestContainerFactory> testContainerFactoryProvider, Function<ExtensionContext, DeploymentContext> deploymentContextProvider, BiFunction<ExtensionContext, ClientConfig, ClientConfig> configProvider) {
        this.testContainerFactoryProvider = testContainerFactoryProvider;
        this.deploymentContextProvider = deploymentContextProvider;
        this.configProvider = configProvider;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        JerseyTest jerseyTest = this.initJerseyTest(context);
        JerseyExtension.getStore(context).put(Client.class, (Object)jerseyTest.client());
        JerseyExtension.getStore(context).put(WebTarget.class, (Object)jerseyTest.target());
        JerseyExtension.getStore(context).put(URI.class, (Object)jerseyTest.target().getUri());
    }

    private JerseyTest initJerseyTest(final ExtensionContext context) throws Exception {
        JerseyTest jerseyTest = new JerseyTest(){

            protected DeploymentContext configureDeployment() {
                this.forceSet("jersey.config.test.container.port", "0");
                return (DeploymentContext)JerseyExtension.this.deploymentContextProvider.apply(context);
            }

            protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
                if (JerseyExtension.this.testContainerFactoryProvider != null) {
                    return (TestContainerFactory)JerseyExtension.this.testContainerFactoryProvider.apply(context);
                }
                return super.getTestContainerFactory();
            }

            protected void configureClient(ClientConfig config) {
                if (JerseyExtension.this.configProvider != null) {
                    config = (ClientConfig)JerseyExtension.this.configProvider.apply(context, config);
                }
                super.configureClient(config);
            }
        };
        jerseyTest.setUp();
        JerseyExtension.getStore(context).put(JerseyTest.class, (Object)jerseyTest);
        return jerseyTest;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = JerseyExtension.getStore(context);
        ((JerseyTest)store.remove(JerseyTest.class, JerseyTest.class)).tearDown();
        INJECTABLE_PARAMETER_TYPES.forEach(arg_0 -> ((ExtensionContext.Store)store).remove(arg_0));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return INJECTABLE_PARAMETER_TYPES.contains(parameterType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return JerseyExtension.getStore(extensionContext).get(parameterType, parameterType);
    }

    public static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.GLOBAL);
    }
}

