/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor;

import com.googlecode.htmlcompressor.analyzer.HtmlAnalyzer;
import com.googlecode.htmlcompressor.compressor.Compressor;
import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdLineCompressor {
    private static final Logger logger = LoggerFactory.getLogger(CmdLineCompressor.class);
    private static final Pattern urlPattern = Pattern.compile("^https?://.*$", 2);
    private boolean helpOpt;
    private boolean analyzeOpt;
    private Charset charsetOpt;
    private String outputFilenameOpt;
    private String patternsFilenameOpt;
    private String typeOpt;
    private String filemaskOpt;
    private boolean recursiveOpt;
    private boolean preserveCommentsOpt;
    private boolean preserveIntertagSpacesOpt;
    private boolean preserveMultiSpacesOpt;
    private boolean removeIntertagSpacesOpt;
    private boolean removeQuotesOpt;
    private String removeSurroundingSpacesOpt;
    private boolean preserveLineBreaksOpt;
    private boolean preservePhpTagsOpt;
    private boolean preserveServerScriptTagsOpt;
    private boolean preserveSsiTagsOpt;
    private boolean compressJsOpt;
    private boolean compressCssOpt;
    private String jsCompressorOpt;
    private boolean simpleDoctypeOpt;
    private boolean removeScriptAttributesOpt;
    private boolean removeStyleAttributesOpt;
    private boolean removeLinkAttributesOpt;
    private boolean removeFormAttributesOpt;
    private boolean removeInputAttributesOpt;
    private boolean simpleBooleanAttributesOpt;
    private boolean removeJavaScriptProtocolOpt;
    private boolean removeHttpProtocolOpt;
    private boolean removeHttpsProtocolOpt;
    private boolean nomungeOpt;
    private int linebreakOpt;
    private boolean preserveSemiOpt;
    private boolean disableOptimizationsOpt;
    private String closureOptLevelOpt;
    private boolean closureCustomExternsOnlyOpt;
    private List<String> closureExternsOpt;
    private List<String> fileArgsOpt;

    public CmdLineCompressor(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
        CmdLineParser.Option helpOptAlt = parser.addBooleanOption('?', "help_alt");
        CmdLineParser.Option analyzeOption = parser.addBooleanOption('a', "analyze");
        CmdLineParser.Option recursiveOption = parser.addBooleanOption('r', "recursive");
        CmdLineParser.Option charsetOption = parser.addStringOption('c', "charset");
        CmdLineParser.Option outputFilenameOption = parser.addStringOption('o', "output");
        CmdLineParser.Option patternsFilenameOption = parser.addStringOption('p', "preserve");
        CmdLineParser.Option typeOption = parser.addStringOption('t', "type");
        CmdLineParser.Option filemaskOption = parser.addStringOption('m', "mask");
        CmdLineParser.Option preserveCommentsOption = parser.addBooleanOption("preserve-comments");
        CmdLineParser.Option preserveIntertagSpacesOption = parser.addBooleanOption("preserve-intertag-spaces");
        CmdLineParser.Option preserveMultiSpacesOption = parser.addBooleanOption("preserve-multi-spaces");
        CmdLineParser.Option removeIntertagSpacesOption = parser.addBooleanOption("remove-intertag-spaces");
        CmdLineParser.Option removeSurroundingSpacesOption = parser.addStringOption("remove-surrounding-spaces");
        CmdLineParser.Option removeQuotesOption = parser.addBooleanOption("remove-quotes");
        CmdLineParser.Option preserveLineBreaksOption = parser.addBooleanOption("preserve-line-breaks");
        CmdLineParser.Option preservePhpTagsOption = parser.addBooleanOption("preserve-php");
        CmdLineParser.Option preserveServerScriptTagsOption = parser.addBooleanOption("preserve-server-script");
        CmdLineParser.Option preserveSsiTagsOption = parser.addBooleanOption("preserve-ssi");
        CmdLineParser.Option compressJsOption = parser.addBooleanOption("compress-js");
        CmdLineParser.Option compressCssOption = parser.addBooleanOption("compress-css");
        CmdLineParser.Option jsCompressorOption = parser.addStringOption("js-compressor");
        CmdLineParser.Option simpleDoctypeOption = parser.addBooleanOption("simple-doctype");
        CmdLineParser.Option removeScriptAttributesOption = parser.addBooleanOption("remove-script-attr");
        CmdLineParser.Option removeStyleAttributesOption = parser.addBooleanOption("remove-style-attr");
        CmdLineParser.Option removeLinkAttributesOption = parser.addBooleanOption("remove-link-attr");
        CmdLineParser.Option removeFormAttributesOption = parser.addBooleanOption("remove-form-attr");
        CmdLineParser.Option removeInputAttributesOption = parser.addBooleanOption("remove-input-attr");
        CmdLineParser.Option simpleBooleanAttributesOption = parser.addBooleanOption("simple-bool-attr");
        CmdLineParser.Option removeJavaScriptProtocolOption = parser.addBooleanOption("remove-js-protocol");
        CmdLineParser.Option removeHttpProtocolOption = parser.addBooleanOption("remove-http-protocol");
        CmdLineParser.Option removeHttpsProtocolOption = parser.addBooleanOption("remove-https-protocol");
        CmdLineParser.Option nomungeOption = parser.addBooleanOption("nomunge");
        CmdLineParser.Option linebreakOption = parser.addStringOption("line-break");
        CmdLineParser.Option preserveSemiOption = parser.addBooleanOption("preserve-semi");
        CmdLineParser.Option disableOptimizationsOption = parser.addBooleanOption("disable-optimizations");
        CmdLineParser.Option closureOptLevelOption = parser.addStringOption("closure-opt-level");
        CmdLineParser.Option closureCustomExternsOnlyOption = parser.addBooleanOption("closure-custom-externs-only");
        CmdLineParser.Option closureExternsOption = parser.addStringOption("closure-externs");
        try {
            parser.parse(args);
            this.helpOpt = (Boolean)parser.getOptionValue(helpOption, false) != false || (Boolean)parser.getOptionValue(helpOptAlt, false) != false;
            this.analyzeOpt = (Boolean)parser.getOptionValue(analyzeOption, false);
            this.recursiveOpt = (Boolean)parser.getOptionValue(recursiveOption, false);
            this.charsetOpt = Charset.forName((String)parser.getOptionValue(charsetOption, "UTF-8"));
            this.outputFilenameOpt = (String)parser.getOptionValue(outputFilenameOption);
            this.patternsFilenameOpt = (String)parser.getOptionValue(patternsFilenameOption);
            this.typeOpt = (String)parser.getOptionValue(typeOption);
            this.filemaskOpt = (String)parser.getOptionValue(filemaskOption);
            this.preserveCommentsOpt = (Boolean)parser.getOptionValue(preserveCommentsOption, false);
            this.preserveIntertagSpacesOpt = (Boolean)parser.getOptionValue(preserveIntertagSpacesOption, false);
            this.preserveMultiSpacesOpt = (Boolean)parser.getOptionValue(preserveMultiSpacesOption, false);
            this.removeIntertagSpacesOpt = (Boolean)parser.getOptionValue(removeIntertagSpacesOption, false);
            this.removeQuotesOpt = (Boolean)parser.getOptionValue(removeQuotesOption, false);
            this.preserveLineBreaksOpt = (Boolean)parser.getOptionValue(preserveLineBreaksOption, false);
            this.preservePhpTagsOpt = (Boolean)parser.getOptionValue(preservePhpTagsOption, false);
            this.preserveServerScriptTagsOpt = (Boolean)parser.getOptionValue(preserveServerScriptTagsOption, false);
            this.preserveSsiTagsOpt = (Boolean)parser.getOptionValue(preserveSsiTagsOption, false);
            this.compressJsOpt = (Boolean)parser.getOptionValue(compressJsOption, false);
            this.compressCssOpt = (Boolean)parser.getOptionValue(compressCssOption, false);
            this.jsCompressorOpt = (String)parser.getOptionValue(jsCompressorOption, "yui");
            this.simpleDoctypeOpt = (Boolean)parser.getOptionValue(simpleDoctypeOption, false);
            this.removeScriptAttributesOpt = (Boolean)parser.getOptionValue(removeScriptAttributesOption, false);
            this.removeStyleAttributesOpt = (Boolean)parser.getOptionValue(removeStyleAttributesOption, false);
            this.removeLinkAttributesOpt = (Boolean)parser.getOptionValue(removeLinkAttributesOption, false);
            this.removeFormAttributesOpt = (Boolean)parser.getOptionValue(removeFormAttributesOption, false);
            this.removeInputAttributesOpt = (Boolean)parser.getOptionValue(removeInputAttributesOption, false);
            this.simpleBooleanAttributesOpt = (Boolean)parser.getOptionValue(simpleBooleanAttributesOption, false);
            this.removeJavaScriptProtocolOpt = (Boolean)parser.getOptionValue(removeJavaScriptProtocolOption, false);
            this.removeHttpProtocolOpt = (Boolean)parser.getOptionValue(removeHttpProtocolOption, false);
            this.removeHttpsProtocolOpt = (Boolean)parser.getOptionValue(removeHttpsProtocolOption, false);
            this.nomungeOpt = (Boolean)parser.getOptionValue(nomungeOption, false);
            this.linebreakOpt = (Integer)parser.getOptionValue(linebreakOption, -1);
            this.preserveSemiOpt = (Boolean)parser.getOptionValue(preserveSemiOption, false);
            this.disableOptimizationsOpt = (Boolean)parser.getOptionValue(disableOptimizationsOption, false);
            this.closureOptLevelOpt = (String)parser.getOptionValue(closureOptLevelOption, "simple");
            this.closureCustomExternsOnlyOpt = (Boolean)parser.getOptionValue(closureCustomExternsOnlyOption, false);
            this.closureExternsOpt = parser.getOptionValues(closureExternsOption);
            this.removeSurroundingSpacesOpt = (String)parser.getOptionValue(removeSurroundingSpacesOption);
            if (this.removeSurroundingSpacesOpt != null) {
                if ("min".equalsIgnoreCase(this.removeSurroundingSpacesOpt)) {
                    this.removeSurroundingSpacesOpt = "html,head,body,br,p";
                } else if ("max".equalsIgnoreCase(this.removeSurroundingSpacesOpt)) {
                    this.removeSurroundingSpacesOpt = "html,head,body,br,p,h1,h2,h3,h4,h5,h6,blockquote,center,dl,fieldset,form,frame,frameset,hr,noframes,ol,table,tbody,tr,td,th,tfoot,thead,ul";
                } else if ("all".equalsIgnoreCase(this.removeSurroundingSpacesOpt)) {
                    this.removeSurroundingSpacesOpt = "all";
                }
            }
            this.fileArgsOpt = parser.getRemainingArgs();
            this.charsetOpt = Charset.isSupported(this.charsetOpt.name()) ? this.charsetOpt : StandardCharsets.UTF_8;
            for (int i = 0; i < args.length; ++i) {
                if (!"/?".equals(args[i])) continue;
                this.helpOpt = true;
                break;
            }
        }
        catch (CmdLineParser.OptionException e) {
            logger.info("{}" + e.getMessage());
            logger.trace("", (Throwable)e);
            this.printUsage();
        }
    }

    public static void main(String[] args) {
        CmdLineCompressor cmdLineCompressor = new CmdLineCompressor(args);
        cmdLineCompressor.process();
    }

    public void process() {
        try {
            if (this.helpOpt) {
                this.printUsage();
                return;
            }
            String type = this.typeOpt;
            if (type != null && !"html".equalsIgnoreCase(type) && !"xml".equalsIgnoreCase(type)) {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
            if (this.fileArgsOpt.isEmpty()) {
                if (type == null) {
                    type = "html";
                }
            } else if (type == null) {
                type = this.fileArgsOpt.get(0).toLowerCase().endsWith(".xml") ? "xml" : "html";
            }
            if (this.analyzeOpt) {
                HtmlAnalyzer analyzer = new HtmlAnalyzer("closure".equalsIgnoreCase(this.jsCompressorOpt) ? "closure" : "yui");
                analyzer.analyze(this.readResource(this.buildReader(this.fileArgsOpt.isEmpty() ? null : this.fileArgsOpt.get(0))));
            } else {
                Compressor compressor = "xml".equalsIgnoreCase(type) ? this.createXmlCompressor() : this.createHtmlCompressor();
                Map<String, String> ioMap = this.buildInputOutputMap();
                for (Map.Entry<String, String> entry : ioMap.entrySet()) {
                    this.writeResource(compressor.compress(this.readResource(this.buildReader(entry.getKey()))), this.buildWriter(entry.getValue()));
                }
            }
        }
        catch (NoClassDefFoundError e) {
            if ("closure".equalsIgnoreCase(this.jsCompressorOpt)) {
                logger.info("ERROR: For JavaScript compression using Google Closure Compiler\nadditional jar file called compiler.jar must be present\nin the same directory as HtmlCompressor jar");
            } else {
                logger.info("ERROR: For CSS or JavaScript compression using YUICompressor additional jar file \ncalled yuicompressor.jar must be present\nin the same directory as HtmlCompressor jar");
            }
            logger.trace("", (Throwable)e);
        }
        catch (CmdLineParser.OptionException e) {
            logger.info("{}" + e.getMessage());
            logger.trace("", (Throwable)e);
            this.printUsage();
        }
        catch (IOException | IllegalArgumentException e) {
            logger.info("{}" + e.getMessage());
            logger.trace("", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private Compressor createHtmlCompressor() throws CmdLineParser.OptionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Compressor createXmlCompressor() throws IllegalArgumentException, CmdLineParser.OptionException {
        XmlCompressor xmlCompressor = new XmlCompressor();
        xmlCompressor.setRemoveComments(!this.preserveCommentsOpt);
        xmlCompressor.setRemoveIntertagSpaces(!this.preserveIntertagSpacesOpt);
        return xmlCompressor;
    }

    private Map<String, String> buildInputOutputMap() throws IllegalArgumentException, IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        File outpuFile = null;
        if (this.outputFilenameOpt != null) {
            outpuFile = new File(this.outputFilenameOpt);
            if (this.outputFilenameOpt.endsWith("/") || this.outputFilenameOpt.endsWith("\\")) {
                outpuFile.mkdirs();
            } else {
                new File(outpuFile.getCanonicalFile().getParent()).mkdirs();
            }
        }
        if (!(this.fileArgsOpt.size() <= 1 || outpuFile != null && outpuFile.isDirectory())) {
            throw new IllegalArgumentException("Output must be a directory and end with a slash (/)");
        }
        if (this.fileArgsOpt.isEmpty()) {
            map.put(null, this.outputFilenameOpt);
        } else {
            for (int i = 0; i < this.fileArgsOpt.size(); ++i) {
                if (!urlPattern.matcher(this.fileArgsOpt.get(i)).matches()) {
                    File inputFile = new File(this.fileArgsOpt.get(i));
                    if (inputFile.isDirectory()) {
                        if (outpuFile != null && outpuFile.isDirectory()) {
                            if (!this.recursiveOpt) {
                                for (File file : inputFile.listFiles(new CompressorFileFilter(this.typeOpt, this.filemaskOpt, false))) {
                                    if (file.isDirectory()) continue;
                                    String from = file.getCanonicalPath();
                                    String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                                    map.put(from, to);
                                }
                                continue;
                            }
                            ArrayDeque<File> fileStack = new ArrayDeque<File>();
                            fileStack.push(inputFile);
                            while (!fileStack.isEmpty()) {
                                File child = (File)fileStack.pop();
                                if (child.isDirectory()) {
                                    for (File f : child.listFiles(new CompressorFileFilter(this.typeOpt, this.filemaskOpt, true))) {
                                        fileStack.push(f);
                                    }
                                    continue;
                                }
                                if (!child.isFile()) continue;
                                String from = child.getCanonicalPath();
                                String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                                map.put(from, to);
                                new File(new File(to).getCanonicalFile().getParent()).mkdirs();
                            }
                            continue;
                        }
                        throw new IllegalArgumentException("Output must be a directory and end with a slash (/)");
                    }
                    if (outpuFile != null && outpuFile.isDirectory()) {
                        String from = inputFile.getCanonicalPath();
                        String to = from.replaceFirst(this.escRegEx(inputFile.getCanonicalFile().getParentFile().getCanonicalPath()), Matcher.quoteReplacement(outpuFile.getCanonicalPath()));
                        map.put(this.fileArgsOpt.get(i), to);
                        continue;
                    }
                    map.put(this.fileArgsOpt.get(i), this.outputFilenameOpt);
                    continue;
                }
                if (!(this.fileArgsOpt.size() != 1 || outpuFile != null && outpuFile.isDirectory())) {
                    map.put(this.fileArgsOpt.get(i), this.outputFilenameOpt);
                    continue;
                }
                throw new IllegalArgumentException("Input URL should be single and cannot have directory as output");
            }
        }
        return map;
    }

    private BufferedReader buildReader(String filename) throws IOException {
        if (filename == null) {
            return new BufferedReader(new InputStreamReader(System.in, this.charsetOpt));
        }
        if (urlPattern.matcher(filename).matches()) {
            return new BufferedReader(new InputStreamReader(new URL(filename).openConnection().getInputStream(), this.charsetOpt));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.charsetOpt));
    }

    private Writer buildWriter(String filename) throws IOException {
        if (filename == null) {
            return new OutputStreamWriter((OutputStream)System.out, this.charsetOpt);
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(filename), this.charsetOpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(BufferedReader input) throws IOException {
        StringBuilder source = new StringBuilder();
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                source.append(line);
                source.append(System.getProperty("line.separator"));
            }
        }
        finally {
            this.closeStream(input);
        }
        return source.toString();
    }

    private void writeResource(String content, Writer output) throws IOException {
        try {
            output.write(content);
        }
        finally {
            this.closeStream(output);
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    private String escRegEx(String inStr) {
        return inStr.replaceAll("([\\\\*+\\[\\](){}\\$.?\\^|])", "\\\\$1");
    }

    private void printUsage() {
        logger.info("Usage: java -jar htmlcompressor.jar [options] [input]\n\n[input]                        URL, filename, directory, or space separated list\n                               of files and directories to compress.\n                               If none provided reads from <stdin>\n\nGlobal Options:\n -?, /?, -h, --help            Displays this help screen\n -t, --type <html|xml>         If not provided autodetects from file extension\n -r, --recursive               Process files inside subdirectories\n -c, --charset <charset>       Charset for reading files, UTF-8 by default\n -m, --mask <filemask>         Filter input files inside directories by mask\n -o, --output <path>           Filename or directory for compression results.\n                               If none provided outputs result to <stdout>\n -a, --analyze                 Tries different settings and displays report.\n                               All settings except --js-compressor are ignored\n\nXML Compression Options:\n --preserve-comments           Preserve comments\n --preserve-intertag-spaces    Preserve intertag spaces\n\nHTML Compression Options:\n --preserve-comments           Preserve comments\n --preserve-multi-spaces       Preserve multiple spaces\n --preserve-line-breaks        Preserve line breaks\n --remove-intertag-spaces      Remove intertag spaces\n --remove-quotes               Remove unneeded quotes\n --simple-doctype              Change doctype to <!DOCTYPE html>\n --remove-style-attr           Remove TYPE attribute from STYLE tags\n --remove-link-attr            Remove TYPE attribute from LINK tags\n --remove-script-attr          Remove TYPE and LANGUAGE from SCRIPT tags\n --remove-form-attr            Remove METHOD=\"GET\" from FORM tags\n --remove-input-attr           Remove TYPE=\"TEXT\" from INPUT tags\n --simple-bool-attr            Remove values from boolean tag attributes\n --remove-js-protocol          Remove \"javascript:\" from inline event handlers\n --remove-http-protocol        Remove \"http:\" from tag attributes\n --remove-https-protocol       Remove \"https:\" from tag attributes\n --remove-surrounding-spaces <min|max|all|custom_list>\n                               Predefined or custom comma separated list of tags\n --compress-js                 Enable inline JavaScript compression\n --compress-css                Enable inline CSS compression using YUICompressor\n --js-compressor <yui|closure> Switch inline JavaScript compressor between\n                               YUICompressor (default) and Closure Compiler\n\nJavaScript Compression Options for YUI Compressor:\n --nomunge                     Minify only, do not obfuscate\n --preserve-semi               Preserve all semicolons\n --disable-optimizations       Disable all micro optimizations\n --line-break <column num>     Insert a line break after the specified column\n\nJavaScript Compression Options for Google Closure Compiler:\n --closure-opt-level <simple|advanced|whitespace>\n                               Sets level of optimization (simple by default)\n --closure-externs <file>      Sets custom externs file, repeat for each file\n --closure-custom-externs-only Disable default built-in externs\n\nCSS Compression Options for YUI Compressor:\n --line-break <column num>     Insert a line break after the specified column\n\nCustom Block Preservation Options:\n --preserve-php                Preserve <?php ... ?> tags\n --preserve-server-script      Preserve <% ... %> tags\n --preserve-ssi                Preserve <!--# ... --> tags\n -p, --preserve <path>         Read regular expressions that define\n                               custom preservation rules from a file\n\nPlease note that if you enable CSS or JavaScript compression, additional\nYUI Compressor or Google Closure Compiler jar files must be present\nin the same directory as this jar.");
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private class CompressorFileFilter
    implements FileFilter {
        private Pattern filemaskPattern;
        private boolean withDirs;

        public CompressorFileFilter(String type, String filemask, boolean withDirs) {
            this.withDirs = withDirs;
            if (filemask == null) {
                this.filemaskPattern = type != null && "xml".equalsIgnoreCase(type) ? Pattern.compile("^.*\\.xml$", 2) : Pattern.compile("^.*\\.html?$", 2);
            } else {
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("."), Matcher.quoteReplacement("\\."));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("*"), Matcher.quoteReplacement(".*"));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx("?"), Matcher.quoteReplacement("."));
                filemask = filemask.replaceAll(CmdLineCompressor.this.escRegEx(";"), Matcher.quoteReplacement("$|^"));
                filemask = "^" + filemask + "$";
                this.filemaskPattern = Pattern.compile(filemask, 2);
            }
        }

        @Override
        public boolean accept(File file) {
            if (!this.withDirs) {
                if (!file.isDirectory()) {
                    return this.filemaskPattern.matcher(file.getName()).matches();
                }
            } else {
                return file.isDirectory() || this.filemaskPattern.matcher(file.getName()).matches();
            }
            return false;
        }
    }
}

