/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.taglib;

import com.googlecode.htmlcompressor.compressor.YuiCssCompressor;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssCompressorTag
extends BodyTagSupport {
    private static final Logger logger = LoggerFactory.getLogger(CssCompressorTag.class);
    private boolean enabled = true;
    private int yuiCssLineBreak = -1;

    public int doEndTag() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        String content = bodyContent.getString();
        try {
            if (this.enabled) {
                YuiCssCompressor compressor = new YuiCssCompressor();
                compressor.setLineBreak(this.yuiCssLineBreak);
                String result = compressor.compress(content);
                bodyContent.clear();
                bodyContent.append((CharSequence)result);
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            } else {
                bodyContent.clear();
                bodyContent.append((CharSequence)content);
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return super.doEndTag();
    }

    public void setYuiCssLineBreak(int yuiCssLineBreak) {
        this.yuiCssLineBreak = yuiCssLineBreak;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

