/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.compressor;

import com.google.common.io.ByteStreams;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import com.googlecode.htmlcompressor.compressor.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureJavaScriptCompressor
implements Compressor {
    private static final Logger logger = LoggerFactory.getLogger(ClosureJavaScriptCompressor.class);
    public static final String COMPILATION_LEVEL_SIMPLE = "simple";
    public static final String COMPILATION_LEVEL_ADVANCED = "advanced";
    public static final String COMPILATION_LEVEL_WHITESPACE = "whitespace";
    private CompilerOptions compilerOptions = new CompilerOptions();
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private Level loggingLevel = Level.SEVERE;
    private WarningLevel warningLevel = WarningLevel.DEFAULT;
    private boolean customExternsOnly;
    private List<SourceFile> externs;

    public ClosureJavaScriptCompressor() {
    }

    public ClosureJavaScriptCompressor(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    @Override
    public String compress(String source) {
        StringWriter writer = new StringWriter();
        ArrayList<SourceFile> input = new ArrayList<SourceFile>();
        input.add(SourceFile.fromCode((String)"source.js", (String)source));
        List<Object> externsList = new ArrayList<SourceFile>();
        if (this.compilationLevel.equals((Object)CompilationLevel.ADVANCED_OPTIMIZATIONS)) {
            if (!this.customExternsOnly) {
                try {
                    externsList = this.getDefaultExterns();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
            if (this.externs != null) {
                for (SourceFile extern : this.externs) {
                    externsList.add(extern);
                }
            }
            if (externsList.isEmpty()) {
                externsList.add(SourceFile.fromCode((String)"externs.js", (String)""));
            }
        } else {
            externsList.add(SourceFile.fromCode((String)"externs.js", (String)""));
        }
        Compiler.setLoggingLevel((Level)this.loggingLevel);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        this.compilationLevel.setOptionsForCompilationLevel(this.compilerOptions);
        this.warningLevel.setOptionsForWarningLevel(this.compilerOptions);
        Result result = compiler.compile(externsList, input, this.compilerOptions);
        if (result.success) {
            writer.write(compiler.toSource());
        } else {
            writer.write(source);
        }
        return writer.toString();
    }

    private List<SourceFile> getDefaultExterns() throws IOException {
        InputStream input = ClosureJavaScriptCompressor.class.getResourceAsStream("/externs.zip");
        ArrayList<SourceFile> externList = new ArrayList<SourceFile>();
        try (ZipInputStream zip = new ZipInputStream(input);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                externList.add(SourceFile.builder().withCharset(Charset.defaultCharset()).withContent(ByteStreams.limit((InputStream)zip, (long)entry.getSize())).withPath(entry.getName()).build());
            }
        }
        return externList;
    }

    public CompilationLevel getCompilationLevel() {
        return this.compilationLevel;
    }

    public void setCompilationLevel(CompilationLevel compilationLevel) {
        this.compilationLevel = compilationLevel;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public List<SourceFile> getExterns() {
        return this.externs;
    }

    public void setExterns(List<SourceFile> externs) {
        this.externs = externs;
    }

    public WarningLevel getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(WarningLevel warningLevel) {
        this.warningLevel = warningLevel;
    }

    public boolean isCustomExternsOnly() {
        return this.customExternsOnly;
    }

    public void setCustomExternsOnly(boolean customExternsOnly) {
        this.customExternsOnly = customExternsOnly;
    }
}

