/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.compressor;

import com.googlecode.htmlcompressor.compressor.Compressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuiJavaScriptCompressor
implements Compressor {
    private static final Logger logger = LoggerFactory.getLogger(YuiJavaScriptCompressor.class);
    private boolean noMunge;
    private boolean preserveAllSemiColons;
    private boolean disableOptimizations;
    private int lineBreak = -1;
    private ErrorReporter errorReporter = new DefaultErrorReporter();

    @Override
    public String compress(String source) {
        StringWriter result = new StringWriter();
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), this.errorReporter);
            compressor.compress((Writer)result, this.lineBreak, !this.noMunge, false, this.preserveAllSemiColons, this.disableOptimizations);
        }
        catch (IOException e) {
            result.write(source);
            logger.error("", (Throwable)e);
        }
        return result.toString();
    }

    public boolean isNoMunge() {
        return this.noMunge;
    }

    public void setNoMunge(boolean noMunge) {
        this.noMunge = noMunge;
    }

    public boolean isPreserveAllSemiColons() {
        return this.preserveAllSemiColons;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public boolean isDisableOptimizations() {
        return this.disableOptimizations;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public int getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(int lineBreak) {
        this.lineBreak = lineBreak;
    }

    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    public static class DefaultErrorReporter
    implements ErrorReporter {
        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.error("[WARNING] HtmlCompressor: '{}' during JavaScript compression", (Object)message);
            } else {
                logger.error("[WARNING] HtmlCompressor: '{}' at line [{}:{}] during JavaScript compression {}", new Object[]{message, line, lineOffset, lineSource != null ? ": " + lineSource : ""});
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.error("[ERROR] HtmlCompressor: '{}' during JavaScript compression", (Object)message);
            } else {
                logger.error("[ERROR] HtmlCompressor: '{}' at line [{}:{}] during JavaScript compression {}", new Object[]{message, line, lineOffset, lineSource != null ? ": " + lineSource : ""});
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

