/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.taglib;

import com.googlecode.htmlcompressor.compressor.XmlCompressor;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCompressorTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(XmlCompressorTag.class);
    private boolean enabled = true;
    private boolean removeComments = true;
    private boolean removeIntertagSpaces = true;

    public int doEndTag() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        String content = bodyContent.getString();
        XmlCompressor compressor = new XmlCompressor();
        compressor.setEnabled(this.enabled);
        compressor.setRemoveComments(this.removeComments);
        compressor.setRemoveIntertagSpaces(this.removeIntertagSpaces);
        try {
            bodyContent.clear();
            bodyContent.append((CharSequence)compressor.compress(content));
            bodyContent.writeOut((Writer)this.pageContext.getOut());
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return super.doEndTag();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public void setRemoveIntertagSpaces(boolean removeIntertagSpaces) {
        this.removeIntertagSpaces = removeIntertagSpaces;
    }
}

