/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.bean;

import com.codebox.bean.ValueBuilder;
import com.codebox.enums.CanEquals;
import com.codebox.enums.CanSerialize;
import com.codebox.enums.LoadData;
import com.codebox.enums.LoadType;
import com.codebox.instance.ClassInstance;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.beans.BeanCopier;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaBeanTesterWorker<T, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaBeanTesterWorker.class);
    private CanSerialize checkSerializable;
    private LoadData loadData;
    private CanEquals checkEquals;
    private Class<T> clazz;
    private Class<E> extension;
    private Set<String> skipThese = new HashSet<String>();

    JavaBeanTesterWorker(Class<T> newClazz) {
        this.clazz = newClazz;
    }

    JavaBeanTesterWorker(Class<T> newClazz, Class<E> newExtension) {
        this.clazz = newClazz;
        this.extension = newExtension;
    }

    public static <L> JavaBeanTesterWorker<L, Object> load(Class<L> clazz, L instance, LoadData loadData, String ... skipThese) {
        JavaBeanTesterWorker worker = new JavaBeanTesterWorker(clazz);
        worker.setLoadData(loadData);
        if (skipThese != null) {
            worker.setSkipThese(new HashSet<String>(Arrays.asList(skipThese)));
        }
        worker.getterSetterTests(instance);
        return worker;
    }

    public void test() {
        this.getterSetterTests(new ClassInstance<T>().newInstance(this.clazz));
        this.constructorsTest();
        this.checkSerializableTest();
        if (this.checkEquals == CanEquals.ON) {
            this.equalsHashCodeToStringSymmetricTest();
        }
    }

    void getterSetterTests(T instance) {
        PropertyDescriptor[] props;
        try {
            props = Introspector.getBeanInfo(this.clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            Assert.fail((String)String.format("An exception was thrown while testing class '%s': '%s'", this.clazz.getName(), e.toString()));
            return;
        }
        block7: for (PropertyDescriptor prop : props) {
            for (String skipThis : this.skipThese) {
                if (!skipThis.equals(prop.getName())) continue;
                continue block7;
            }
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length != 1 || params[0] != returnType) continue;
            try {
                Object value = this.buildValue(returnType, LoadType.STANDARD_DATA);
                setter.invoke(instance, value);
                Object expectedValue = value;
                Object actualValue = getter.invoke(instance, new Object[0]);
                Assert.assertEquals((String)String.format("Failed while testing property '%s'", prop.getName()), (Object)expectedValue, (Object)actualValue);
            }
            catch (IllegalAccessException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (InvocationTargetException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (SecurityException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
        }
    }

    void constructorsTest() {
        for (Constructor<?> constructor : this.clazz.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            Object[] values = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.buildValue(types[i], LoadType.STANDARD_DATA);
            }
            try {
                constructor.newInstance(values);
            }
            catch (InstantiationException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the constructor '%s': '%s'", constructor.getName(), e.toString()));
            }
            catch (IllegalAccessException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the constructor '%s': '%s'", constructor.getName(), e.toString()));
            }
            catch (InvocationTargetException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the constructor '%s': '%s'", constructor.getName(), e.toString()));
            }
        }
    }

    void checkSerializableTest() {
        Object object = new ClassInstance<T>().newInstance(this.clazz);
        if (this.implementsSerializable(object)) {
            this.canSerialize(object);
            return;
        }
        if (this.checkSerializable == CanSerialize.ON) {
            Assert.fail((String)String.format("Class is not serializable '%s'", object.getClass().getName()));
        }
    }

    boolean implementsSerializable(T object) {
        return object instanceof Serializable || object instanceof Externalizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void canSerialize(T object) {
        ObjectOutputStream output = null;
        output = new ObjectOutputStream(new ByteArrayOutputStream());
        output.writeObject(object);
        if (output == null) return;
        try {
            output.close();
            return;
        }
        catch (IOException e) {
            Assert.fail((String)String.format("An exception was thrown while closing stream for class '%s': '%s',", object.getClass().getName(), e.toString()));
        }
        return;
        catch (IOException e) {
            try {
                Assert.fail((String)String.format("An exception was thrown while serializing the class '%s': '%s',", object.getClass().getName(), e.toString()));
                if (output == null) return;
            }
            catch (Throwable throwable) {
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    Assert.fail((String)String.format("An exception was thrown while closing stream for class '%s': '%s',", object.getClass().getName(), e2.toString()));
                }
                throw throwable;
            }
            try {
                output.close();
                return;
            }
            catch (IOException e3) {
                Assert.fail((String)String.format("An exception was thrown while closing stream for class '%s': '%s',", object.getClass().getName(), e3.toString()));
            }
            return;
        }
    }

    private <R> Object buildValue(Class<R> returnType, LoadType loadType) {
        ValueBuilder valueBuilder = new ValueBuilder();
        valueBuilder.setLoadData(this.loadData);
        return valueBuilder.buildValue(returnType, loadType);
    }

    public void equalsHashCodeToStringSymmetricTest() {
        Object x = new ClassInstance<T>().newInstance(this.clazz);
        Object y = new ClassInstance<T>().newInstance(this.clazz);
        Object ext = new ClassInstance<E>().newInstance(this.extension);
        Assert.assertEquals(x, y);
        Assert.assertEquals((long)x.hashCode(), (long)y.hashCode());
        Assert.assertEquals((Object)x.toString(), (Object)y.toString());
        Assert.assertNotEquals(ext, y);
        Assert.assertNotEquals((long)ext.hashCode(), (long)y.hashCode());
        Assert.assertNotEquals(x, null);
        Assert.assertEquals(x, x);
        Assert.assertNotEquals(ext, null);
        Assert.assertEquals(ext, ext);
        JavaBeanTesterWorker.load(this.clazz, x, this.loadData, new String[0]);
        JavaBeanTesterWorker.load(this.extension, ext, this.loadData, new String[0]);
        Assert.assertNotEquals(y, x);
        Assert.assertNotEquals(y, ext);
        JavaBeanTesterWorker.load(this.clazz, y, this.loadData, new String[0]);
        if (this.loadData == LoadData.ON) {
            Assert.assertEquals(x, y);
            Assert.assertEquals((long)x.hashCode(), (long)y.hashCode());
        } else {
            Assert.assertNotEquals(x, y);
            Assert.assertNotEquals((long)x.hashCode(), (long)y.hashCode());
        }
        Assert.assertNotEquals(ext, y);
        Assert.assertNotEquals((long)ext.hashCode(), (long)y.hashCode());
        Assert.assertNotEquals((Object)ext.toString(), (Object)y.toString());
        try {
            BeanCopier clazzBeanCopier = BeanCopier.create(this.clazz, this.clazz, (boolean)false);
            Object e = new ClassInstance<T>().newInstance(this.clazz);
            clazzBeanCopier.copy(x, e, null);
            Assert.assertEquals(e, x);
        }
        catch (Exception e) {
            LOGGER.trace("Do nothing class is not mutable", (Object)e.toString());
        }
        try {
            BeanCopier extensionBeanCopier = BeanCopier.create(this.extension, this.extension, (boolean)false);
            Object e2 = new ClassInstance<E>().newInstance(this.extension);
            extensionBeanCopier.copy(ext, e2, null);
            Assert.assertEquals(e2, ext);
        }
        catch (Exception e) {
            LOGGER.trace("Do nothing class is not mutable", (Object)e.toString());
        }
    }

    void equalsTests(T instance, T expected) {
        PropertyDescriptor[] props;
        if (expected.hashCode() == instance.hashCode()) {
            Assert.assertEquals((long)expected.hashCode(), (long)instance.hashCode());
        } else {
            Assert.assertNotEquals((long)expected.hashCode(), (long)instance.hashCode());
        }
        ValueBuilder valueBuilder = new ValueBuilder();
        valueBuilder.setLoadData(this.loadData);
        try {
            props = Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            Assert.fail((String)String.format("An exception occurred during introspection of '%s': '%s'", instance.getClass().getName(), e.toString()));
            return;
        }
        for (PropertyDescriptor prop : props) {
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length != 1 || params[0] != returnType) continue;
            try {
                Object original = getter.invoke(instance, new Object[0]);
                Object value = valueBuilder.buildValue(returnType, LoadType.ALTERNATE_DATA);
                setter.invoke(instance, value);
                if (instance.equals(expected)) {
                    Assert.assertEquals(expected, instance);
                } else {
                    Assert.assertNotEquals(expected, instance);
                }
                value = valueBuilder.buildValue(returnType, LoadType.NULL_DATA);
                setter.invoke(instance, value);
                if (instance.equals(expected)) {
                    Assert.assertEquals(expected, instance);
                } else {
                    Assert.assertNotEquals(expected, instance);
                }
                setter.invoke(instance, original);
            }
            catch (IllegalAccessException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (InvocationTargetException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
            catch (SecurityException e) {
                Assert.fail((String)String.format("An exception was thrown while testing the property '%s': '%s'", prop.getName(), e.toString()));
            }
        }
    }

    public CanSerialize getCheckSerializable() {
        return this.checkSerializable;
    }

    public LoadData getLoadData() {
        return this.loadData;
    }

    public CanEquals getCheckEquals() {
        return this.checkEquals;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Class<E> getExtension() {
        return this.extension;
    }

    public Set<String> getSkipThese() {
        return this.skipThese;
    }

    public void setCheckSerializable(CanSerialize checkSerializable) {
        this.checkSerializable = checkSerializable;
    }

    public void setLoadData(LoadData loadData) {
        this.loadData = loadData;
    }

    public void setCheckEquals(CanEquals checkEquals) {
        this.checkEquals = checkEquals;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setExtension(Class<E> extension) {
        this.extension = extension;
    }

    public void setSkipThese(Set<String> skipThese) {
        this.skipThese = skipThese;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaBeanTesterWorker)) {
            return false;
        }
        JavaBeanTesterWorker other = (JavaBeanTesterWorker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CanSerialize this$checkSerializable = this.getCheckSerializable();
        CanSerialize other$checkSerializable = other.getCheckSerializable();
        if (this$checkSerializable == null ? other$checkSerializable != null : !((Object)((Object)this$checkSerializable)).equals((Object)other$checkSerializable)) {
            return false;
        }
        LoadData this$loadData = this.getLoadData();
        LoadData other$loadData = other.getLoadData();
        if (this$loadData == null ? other$loadData != null : !((Object)((Object)this$loadData)).equals((Object)other$loadData)) {
            return false;
        }
        CanEquals this$checkEquals = this.getCheckEquals();
        CanEquals other$checkEquals = other.getCheckEquals();
        if (this$checkEquals == null ? other$checkEquals != null : !((Object)((Object)this$checkEquals)).equals((Object)other$checkEquals)) {
            return false;
        }
        Class<T> this$clazz = this.getClazz();
        Class<T> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Class<E> this$extension = this.getExtension();
        Class<E> other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        Set<String> this$skipThese = this.getSkipThese();
        Set<String> other$skipThese = other.getSkipThese();
        return !(this$skipThese == null ? other$skipThese != null : !((Object)this$skipThese).equals(other$skipThese));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaBeanTesterWorker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CanSerialize $checkSerializable = this.getCheckSerializable();
        result = result * 59 + ($checkSerializable == null ? 43 : ((Object)((Object)$checkSerializable)).hashCode());
        LoadData $loadData = this.getLoadData();
        result = result * 59 + ($loadData == null ? 43 : ((Object)((Object)$loadData)).hashCode());
        CanEquals $checkEquals = this.getCheckEquals();
        result = result * 59 + ($checkEquals == null ? 43 : ((Object)((Object)$checkEquals)).hashCode());
        Class<T> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Class<E> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        Set<String> $skipThese = this.getSkipThese();
        result = result * 59 + ($skipThese == null ? 43 : ((Object)$skipThese).hashCode());
        return result;
    }

    public String toString() {
        return "JavaBeanTesterWorker(checkSerializable=" + (Object)((Object)this.getCheckSerializable()) + ", loadData=" + (Object)((Object)this.getLoadData()) + ", checkEquals=" + (Object)((Object)this.getCheckEquals()) + ", clazz=" + this.getClazz() + ", extension=" + this.getExtension() + ", skipThese=" + this.getSkipThese() + ")";
    }
}

