/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.bean;

import com.codebox.bean.JavaBeanTesterWorker;
import com.codebox.enums.LoadData;
import com.codebox.enums.LoadType;
import com.codebox.instance.ClassInstance;
import com.codebox.instance.ConstructorInstance;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueBuilder {
    private LoadData loadData;

    public <T> Object buildValue(Class<T> clazz, LoadType loadType) {
        Constructor<?>[] ctrs;
        for (Constructor<?> ctr : ctrs = clazz.getConstructors()) {
            if (ctr.getParameterTypes().length != 0 || clazz == String.class) continue;
            if (this.loadData == LoadData.ON) {
                JavaBeanTesterWorker beanTesterWorker = new JavaBeanTesterWorker(clazz);
                beanTesterWorker.setLoadData(this.loadData);
                beanTesterWorker.getterSetterTests(new ClassInstance<T>().newInstance(clazz));
                return null;
            }
            return ConstructorInstance.newInstance(ctr);
        }
        Object returnObject = null;
        switch (loadType) {
            case ALTERNATE_DATA: {
                returnObject = ValueBuilder.setAlternateValues(clazz);
                break;
            }
            case NULL_DATA: {
                returnObject = ValueBuilder.setNullValues(clazz);
                break;
            }
            default: {
                returnObject = ValueBuilder.setStandardValues(clazz);
            }
        }
        if (returnObject != null || loadType == LoadType.NULL_DATA) {
            return returnObject;
        }
        if (clazz.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(Map.class)) {
            return new HashMap();
        }
        if (clazz.isAssignableFrom(ConcurrentMap.class)) {
            return new ConcurrentHashMap();
        }
        if (clazz == Logger.class) {
            return LoggerFactory.getLogger(clazz);
        }
        return null;
    }

    private static <T> Object setAlternateValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, "ALT_VALUE", 1, Boolean.FALSE, 2, 2L, 2.0, Float.valueOf(2.0f), Character.valueOf('N'), (byte)2);
    }

    private static <T> Object setNullValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, null, 0, null, null, null, null, null, null, null);
    }

    private static <T> Object setStandardValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, "TEST_VALUE", 1, Boolean.TRUE, 1, 1L, 1.0, Float.valueOf(1.0f), Character.valueOf('Y'), (byte)1);
    }

    private static <T> Object setValues(Class<T> clazz, String string, int arrayLength, Boolean booleanValue, Integer integerValue, Long longValue, Double doubleValue, Float floatValue, Character characterValue, Byte byteValue) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), arrayLength);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (clazz == Boolean.TYPE && booleanValue == null) {
                return Boolean.FALSE;
            }
            return booleanValue;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (clazz == Integer.TYPE && integerValue == null) {
                return -1;
            }
            return integerValue;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (clazz == Long.TYPE && longValue == null) {
                return -1L;
            }
            return longValue;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (clazz == Double.TYPE && doubleValue == null) {
                return -1.0;
            }
            return doubleValue;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            if (clazz == Float.TYPE && floatValue == null) {
                return Float.valueOf(-1.0f);
            }
            return floatValue;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            if (clazz == Character.TYPE && characterValue == null) {
                return Character.valueOf('\u0000');
            }
            return characterValue;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            if (clazz == Byte.TYPE && byteValue == null) {
                return (byte)-1;
            }
            return byteValue;
        }
        return null;
    }

    public LoadData getLoadData() {
        return this.loadData;
    }

    public void setLoadData(LoadData loadData) {
        this.loadData = loadData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueBuilder)) {
            return false;
        }
        ValueBuilder other = (ValueBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadData this$loadData = this.getLoadData();
        LoadData other$loadData = other.getLoadData();
        return !(this$loadData == null ? other$loadData != null : !((Object)((Object)this$loadData)).equals((Object)other$loadData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadData $loadData = this.getLoadData();
        result = result * 59 + ($loadData == null ? 43 : ((Object)((Object)$loadData)).hashCode());
        return result;
    }

    public String toString() {
        return "ValueBuilder(loadData=" + (Object)((Object)this.getLoadData()) + ")";
    }
}

