/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.bean;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ByteBuddyBeanCopier {
    private ByteBuddyBeanCopier() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static void copy(Object source, Object target, BooleanConverter converter) {
        if (source == null || target == null) {
            return;
        }
        Class<?> clazz = source.getClass();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : clazz.getMethods()) {
            String property;
            if (ByteBuddyBeanCopier.isGetter(method)) {
                property = ByteBuddyBeanCopier.decapitalize(ByteBuddyBeanCopier.extractPropertyName(method));
                getters.put(property, method);
                continue;
            }
            if (!ByteBuddyBeanCopier.isSetter(method)) continue;
            property = ByteBuddyBeanCopier.decapitalize(method.getName().substring(3));
            setters.put(property, method);
        }
        for (Map.Entry entry : setters.entrySet()) {
            String property = (String)entry.getKey();
            Method setter = (Method)entry.getValue();
            Method getter = (Method)getters.get(property);
            try {
                Object value = null;
                if (getter != null) {
                    value = getter.invoke(source, new Object[0]);
                } else if (ByteBuddyBeanCopier.isBooleanType(setter.getParameterTypes()[0])) {
                    String isMethodName = "is" + ByteBuddyBeanCopier.capitalize(property);
                    try {
                        Method isMethod = clazz.getMethod(isMethodName, new Class[0]);
                        if (ByteBuddyBeanCopier.isBooleanType(isMethod.getReturnType())) {
                            value = isMethod.invoke(source, new Object[0]);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (converter != null && ByteBuddyBeanCopier.isBooleanType(setter.getParameterTypes()[0])) {
                    value = converter.convert(value, setter.getParameterTypes()[0]);
                }
                if (value == null && setter.getParameterTypes()[0].isPrimitive()) continue;
                setter.invoke(target, value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to copy property: " + property, e);
            }
        }
    }

    private static boolean isGetter(Method method) {
        if (method.getParameterCount() != 0) {
            return false;
        }
        String name = method.getName();
        return name.startsWith("get") && !method.getReturnType().equals(Void.TYPE) && name.length() > 3 || name.startsWith("is") && ByteBuddyBeanCopier.isBooleanType(method.getReturnType()) && name.length() > 2;
    }

    private static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getParameterCount() == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isBooleanType(Class<?> type) {
        return type == Boolean.TYPE || type == Boolean.class;
    }

    private static String extractPropertyName(Method getter) {
        String name = getter.getName();
        if (name.startsWith("get")) {
            return name.substring(3);
        }
        if (name.startsWith("is")) {
            return name.substring(2);
        }
        throw new IllegalArgumentException("Not a getter method: " + name);
    }

    private static String decapitalize(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private static String capitalize(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static interface BooleanConverter {
        public Object convert(Object var1, Class<?> var2);
    }
}

