/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.builders;

import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBuilder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionBuilder.class);

    public Class<?> generate(Class<T> clazz) throws NotFoundException, CannotCompileException {
        try {
            return Class.forName(clazz.getName() + "Extension");
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("No extension exists, so create it", (Throwable)e);
            ClassPool pool = ClassPool.getDefault();
            CtClass cc = pool.makeClass(clazz.getName() + "Extension");
            cc.setSuperclass(ExtensionBuilder.resolveCtClass(clazz));
            HashMap<String, Class<String>> properties = new HashMap<String, Class<String>>();
            properties.put("jbExtension1", String.class);
            properties.put("jbExtension2", String.class);
            properties.put("jbExtension3", String.class);
            properties.put("jbExtension4", String.class);
            for (Map.Entry entry : properties.entrySet()) {
                cc.addField(new CtField(ExtensionBuilder.resolveCtClass((Class)entry.getValue()), (String)entry.getKey(), cc));
                cc.addMethod(ExtensionBuilder.generateGetter(cc, (String)entry.getKey(), (Class)entry.getValue()));
                cc.addMethod(ExtensionBuilder.generateSetter(cc, (String)entry.getKey(), (Class)entry.getValue()));
            }
            return cc.toClass();
        }
    }

    private static CtMethod generateGetter(CtClass declaringClass, String fieldName, Class<?> fieldClass) throws CannotCompileException {
        String methodSrc = "public %s get%s() {\n    return this.%s;\n}\n".formatted(fieldClass.getName(), fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), fieldName);
        return CtMethod.make((String)methodSrc, (CtClass)declaringClass);
    }

    private static CtMethod generateSetter(CtClass declaringClass, String fieldName, Class<?> fieldClass) throws CannotCompileException {
        String methodSrc = "public void set%s(%s %s) {\n    this.%s = %s;\n}\n".formatted(fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), fieldClass.getName(), fieldName, fieldName, fieldName);
        return CtMethod.make((String)methodSrc, (CtClass)declaringClass);
    }

    private static CtClass resolveCtClass(Class<?> clazz) throws NotFoundException {
        return ClassPool.getDefault().get(clazz.getName());
    }
}

