/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.bean;

import com.codebox.bean.JavaBeanTesterWorker;
import com.codebox.enums.LoadData;
import com.codebox.enums.LoadType;
import com.codebox.instance.ClassInstance;
import com.codebox.instance.ConstructorInstance;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ValueBuilder.class);
    private LoadData loadData;

    public <T> Object buildValue(Class<T> clazz, LoadType loadType) {
        Constructor<?>[] ctrs;
        for (Constructor<?> ctr : ctrs = clazz.getConstructors()) {
            if (ctr.getParameterTypes().length != 0 || clazz == String.class) continue;
            if (this.loadData == LoadData.ON) {
                JavaBeanTesterWorker beanTesterWorker = new JavaBeanTesterWorker(clazz);
                beanTesterWorker.setLoadData(this.loadData);
                beanTesterWorker.getterSetterTests(new ClassInstance<T>().newInstance(clazz));
                return null;
            }
            return ConstructorInstance.newInstance(ctr);
        }
        Object returnObject = null;
        switch (loadType) {
            case ALTERNATE_DATA: {
                returnObject = ValueBuilder.setAlternateValues(clazz);
                break;
            }
            case NULL_DATA: {
                returnObject = ValueBuilder.setNullValues(clazz);
                break;
            }
            default: {
                returnObject = ValueBuilder.setStandardValues(clazz);
            }
        }
        if (returnObject != null || loadType == LoadType.NULL_DATA) {
            return returnObject;
        }
        if (clazz.isAssignableFrom(List.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(Map.class)) {
            return new HashMap();
        }
        if (clazz.isAssignableFrom(ConcurrentMap.class)) {
            return new ConcurrentHashMap();
        }
        if (clazz.isAssignableFrom(Date.class)) {
            return new Date();
        }
        if (clazz.isAssignableFrom(LocalDate.class)) {
            return LocalDate.now();
        }
        if (clazz.isAssignableFrom(LocalDateTime.class)) {
            return LocalDateTime.of(2000, 10, 1, 0, 0);
        }
        if (clazz.isAssignableFrom(LocalTime.class)) {
            return LocalTime.of(0, 0);
        }
        if (clazz.isAssignableFrom(ZonedDateTime.class)) {
            return ZonedDateTime.of(LocalDateTime.of(2020, 11, 16, 10, 26, 0, 1), ZoneId.of("UTC"));
        }
        if (clazz == Logger.class) {
            return LoggerFactory.getLogger(clazz);
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        logger.warn("Unable to build value for class '{}', please raise ticket with JavaBeanTester for desired support.", (Object)clazz.getName());
        return null;
    }

    private static <T> Object setAlternateValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, "ALT_VALUE", 1, Boolean.FALSE, 2, 2L, 2.0, Float.valueOf(2.0f), Character.valueOf('N'), (byte)2);
    }

    private static <T> Object setNullValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, null, 0, null, null, null, null, null, null, null);
    }

    private static <T> Object setStandardValues(Class<T> clazz) {
        return ValueBuilder.setValues(clazz, "TEST_VALUE", 1, Boolean.TRUE, 1, 1L, 1.0, Float.valueOf(1.0f), Character.valueOf('Y'), (byte)1);
    }

    private static <T> Object setValues(Class<T> clazz, String string, int arrayLength, Boolean booleanValue, Integer integerValue, Long longValue, Double doubleValue, Float floatValue, Character characterValue, Byte byteValue) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), arrayLength);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return ValueBuilder.initializeBoolean(clazz, booleanValue);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return ValueBuilder.initializeInteger(clazz, integerValue);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return ValueBuilder.initializeLong(clazz, longValue);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return ValueBuilder.initializeDouble(clazz, doubleValue);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return ValueBuilder.initializeFloat(clazz, floatValue);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return ValueBuilder.initializeCharacter(clazz, characterValue);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return ValueBuilder.initializeByte(clazz, byteValue);
        }
        return null;
    }

    private static <T> Object initializeBoolean(Class<T> clazz, Boolean booleanValue) {
        if (clazz == Boolean.TYPE && booleanValue == null) {
            return Boolean.FALSE;
        }
        return booleanValue;
    }

    private static <T> Object initializeInteger(Class<T> clazz, Integer integerValue) {
        if (clazz == Integer.TYPE && integerValue == null) {
            return -1;
        }
        return integerValue;
    }

    private static <T> Object initializeLong(Class<T> clazz, Long longValue) {
        if (clazz == Long.TYPE && longValue == null) {
            return -1L;
        }
        return longValue;
    }

    private static <T> Object initializeDouble(Class<T> clazz, Double doubleValue) {
        if (clazz == Double.TYPE && doubleValue == null) {
            return -1.0;
        }
        return doubleValue;
    }

    private static <T> Object initializeFloat(Class<T> clazz, Float floatValue) {
        if (clazz == Float.TYPE && floatValue == null) {
            return Float.valueOf(-1.0f);
        }
        return floatValue;
    }

    private static <T> Object initializeCharacter(Class<T> clazz, Character characterValue) {
        if (clazz == Character.TYPE && characterValue == null) {
            return Character.valueOf('\u0000');
        }
        return characterValue;
    }

    private static <T> Object initializeByte(Class<T> clazz, Byte byteValue) {
        if (clazz == Byte.TYPE && byteValue == null) {
            return (byte)-1;
        }
        return byteValue;
    }

    public LoadData getLoadData() {
        return this.loadData;
    }

    public void setLoadData(LoadData loadData) {
        this.loadData = loadData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueBuilder)) {
            return false;
        }
        ValueBuilder other = (ValueBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoadData this$loadData = this.getLoadData();
        LoadData other$loadData = other.getLoadData();
        return !(this$loadData == null ? other$loadData != null : !((Object)((Object)this$loadData)).equals((Object)other$loadData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoadData $loadData = this.getLoadData();
        result = result * 59 + ($loadData == null ? 43 : ((Object)((Object)$loadData)).hashCode());
        return result;
    }

    public String toString() {
        return "ValueBuilder(loadData=" + (Object)((Object)this.getLoadData()) + ")";
    }
}

