/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.instance;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.Assertions;

public final class ConstructorInstance {
    private ConstructorInstance() {
    }

    public static Object newInstance(Constructor<?> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Assertions.fail((String)String.format("An exception was thrown while testing the constructor (new instance) '%s': '%s'", constructor.getName(), e.toString()));
            return null;
        }
    }

    public static void inaccessible(Class<?> clazz) {
        Constructor<?>[] ctors = clazz.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)ctors.length, (String)"Utility class should only have one constructor");
        Constructor<?> ctor = ctors[0];
        Assertions.assertFalse((boolean)ctor.isAccessible(), (String)"Utility class constructor should be inaccessible");
        ctor.setAccessible(true);
        Object object = ConstructorInstance.newInstance(ctor);
        Assertions.assertEquals(clazz, (Object)(object == null ? "null" : object.getClass()), (String)"You would expect the constructor to return the expected type");
    }
}

