/*
 * Decompiled with CFR 0.152.
 */
package com.codebox.bean;

import com.codebox.bean.ValueBuilder;
import com.codebox.enums.CheckClear;
import com.codebox.enums.CheckConstructor;
import com.codebox.enums.CheckEquals;
import com.codebox.enums.CheckSerialize;
import com.codebox.enums.LoadData;
import com.codebox.enums.LoadType;
import com.codebox.enums.SkipStrictSerialize;
import com.codebox.instance.ClassInstance;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanCopier;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaBeanTesterWorker<T, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaBeanTesterWorker.class);
    private CheckClear checkClear;
    private CheckConstructor checkConstructor;
    private CheckEquals checkEquals;
    private CheckSerialize checkSerializable;
    private LoadData loadData;
    private final Class<T> clazz;
    private Class<E> extension;
    private SkipStrictSerialize skipStrictSerializable;
    private Set<String> skipThese = new HashSet<String>();

    JavaBeanTesterWorker(Class<T> newClazz) {
        this.clazz = newClazz;
    }

    JavaBeanTesterWorker(Class<T> newClazz, Class<E> newExtension) {
        this.clazz = newClazz;
        this.extension = newExtension;
    }

    public static <L> JavaBeanTesterWorker<L, Object> load(Class<L> clazz, L instance, LoadData loadData, String ... skipThese) {
        JavaBeanTesterWorker worker = new JavaBeanTesterWorker(clazz);
        worker.setLoadData(loadData);
        if (skipThese != null) {
            worker.setSkipThese(new HashSet<String>(Arrays.asList(skipThese)));
        }
        worker.getterSetterTests(instance);
        return worker;
    }

    public void test() {
        this.getterSetterTests(new ClassInstance<T>().newInstance(this.clazz));
        if (this.checkClear != CheckClear.OFF) {
            this.clearTest();
        }
        if (this.checkConstructor != CheckConstructor.OFF) {
            this.constructorsTest();
        }
        this.checkSerializableTest();
        if (this.checkEquals == CheckEquals.ON) {
            this.equalsHashCodeToStringSymmetricTest();
        }
    }

    void getterSetterTests(T instance) {
        PropertyDescriptor[] props;
        for (PropertyDescriptor prop : props = this.getProps(this.clazz)) {
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (getter == null && setter != null) {
                String isBooleanWrapper = "is" + setter.getName().substring(3);
                try {
                    getter = this.clazz.getMethod(isBooleanWrapper, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length != 1 || params[0] != returnType) continue;
            try {
                Object value = this.buildValue(returnType, LoadType.STANDARD_DATA);
                Object bean = new ClassInstance<T>().newInstance(this.clazz);
                setter.invoke(bean, value);
                setter.invoke(instance, value);
                Object expectedValue = value;
                Object actualValue = getter.invoke(bean, new Object[0]);
                if (this.clazz == Date.class && prop.getName().equals("month") && expectedValue.equals(Integer.valueOf("1")) && actualValue.equals(Integer.valueOf("2"))) {
                    actualValue = Integer.valueOf("1");
                }
                Assertions.assertEquals((Object)expectedValue, (Object)actualValue, (String)String.format("Failed while testing property '%s' of class '%s'", prop.getName(), this.clazz.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                Assertions.fail((String)String.format("An exception was thrown while testing class '%s' with the property (getter/setter) '%s': '%s'", this.clazz.getName(), prop.getName(), e.toString()));
            }
        }
    }

    void clearTest() {
        Method[] methods;
        for (Method method : methods = this.clazz.getDeclaredMethods()) {
            if (!method.getName().equals("clear")) continue;
            Object newClass = new ClassInstance<T>().newInstance(this.clazz);
            Object expectedClass = new ClassInstance<T>().newInstance(this.clazz);
            try {
                List<Annotation> annotations = null;
                for (Method mt : methods) {
                    annotations = Arrays.asList(mt.getAnnotations());
                    for (Annotation annotation : annotations) {
                        if (!"PostConstruct".equals(annotation.annotationType().getSimpleName()) || mt.getParameterTypes().length != 0) continue;
                        mt.invoke(newClass, new Object[0]);
                        mt.invoke(expectedClass, new Object[0]);
                    }
                }
                newClass.getClass().getMethod("clear", new Class[0]).invoke(newClass, new Object[0]);
                Assertions.assertEquals(expectedClass, newClass, (String)String.format("Clear method does not match new object '%s'", this.clazz));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Assertions.fail((String)String.format("An exception was thrown while testing the Clear method '%s' : '%s'", this.clazz.getName(), e.toString()));
            }
        }
    }

    void constructorsTest() {
        for (Constructor<?> constructor : this.clazz.getConstructors()) {
            if (constructor.isAnnotationPresent(Deprecated.class)) continue;
            Class<?>[] types = constructor.getParameterTypes();
            Object[] values = new Object[constructor.getParameterTypes().length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.buildValue(types[i], LoadType.STANDARD_DATA);
            }
            try {
                constructor.newInstance(values);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Assertions.fail((String)String.format("An exception was thrown while testing the constructor(s) '%s' with '%s': '%s'", constructor.getName(), Arrays.toString(values), e.toString()));
            }
        }
    }

    void checkSerializableTest() {
        Object object = new ClassInstance<T>().newInstance(this.clazz);
        if (this.implementsSerializable(object)) {
            Object newObject = this.canSerialize(object);
            if (this.skipStrictSerializable != SkipStrictSerialize.ON) {
                Assertions.assertEquals(object, newObject);
            } else {
                Assertions.assertNotEquals(object, newObject);
            }
            return;
        }
        if (this.checkSerializable == CheckSerialize.ON) {
            Assertions.fail((String)String.format("Class is not serializable '%s'", object.getClass().getName()));
        }
    }

    boolean implementsSerializable(T object) {
        return object instanceof Serializable || object instanceof Externalizable;
    }

    T canSerialize(T object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(baos).writeObject(object);
        }
        catch (IOException e) {
            Assertions.fail((String)String.format("An exception was thrown while serializing the class '%s': '%s',", object.getClass().getName(), e.toString()));
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            return (T)new ObjectInputStream(bais).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Assertions.fail((String)String.format("An exception was thrown while deserializing the class '%s': '%s',", object.getClass().getName(), e.toString()));
            return null;
        }
    }

    private <R> Object buildValue(Class<R> returnType, LoadType loadType) {
        ValueBuilder valueBuilder = new ValueBuilder();
        valueBuilder.setLoadData(this.loadData);
        return valueBuilder.buildValue(returnType, loadType);
    }

    public void equalsHashCodeToStringSymmetricTest() {
        Object e;
        try {
            EqualsVerifier.simple().forClass(this.clazz).verify();
        }
        catch (AssertionError e2) {
            LOGGER.warn("EqualsVerifier attempt failed: {}", (Object)((Throwable)((Object)e2)).getMessage());
        }
        Object x = new ClassInstance<T>().newInstance(this.clazz);
        Object y = new ClassInstance<T>().newInstance(this.clazz);
        Assertions.assertNotNull(x, (String)String.format("Create new instance of class '%s' resulted in null", this.clazz.getName()));
        Assertions.assertNotNull(y, (String)String.format("Create new instance of class '%s' resulted in null", this.clazz.getName()));
        Object ext = new ClassInstance<E>().newInstance(this.extension);
        Assertions.assertNotNull(ext, (String)String.format("Create new instance of extension %s resulted in null", this.extension.getName()));
        Assertions.assertEquals(x, y, (String)String.format(".equals() should be consistent for two empty objects of type %s", this.clazz.getName()));
        Assertions.assertEquals((int)x.hashCode(), (int)y.hashCode(), (String)String.format(".hashCode() should be consistent for two empty objects of type %s", this.clazz.getName()));
        Assertions.assertEquals((Object)x.toString(), (Object)y.toString(), (String)String.format(".toString() should be consistent for two empty objects of type %s", this.clazz.getName()));
        Assertions.assertNotEquals(ext, y, (String)String.format(".equals() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
        Assertions.assertNotEquals((int)ext.hashCode(), (int)y.hashCode(), (String)String.format(".hashCode() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
        Assertions.assertNotEquals((Object)ext.toString(), (Object)y.toString(), (String)String.format(".toString() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
        Assertions.assertNotEquals(x, null, (String)String.format("An empty object of type %s should not be equal to null", this.clazz.getName()));
        Assertions.assertEquals(x, x, (String)String.format("An empty object of type %s should be equal to itself", this.clazz.getName()));
        Assertions.assertNotEquals(ext, null, (String)String.format("An empty extension of type %s should not be equal to null", this.clazz.getName()));
        Assertions.assertEquals(ext, ext, (String)String.format("An empty extension of type %s should be equal to itself", this.extension.getName()));
        if (this.classHasSetters(this.clazz)) {
            JavaBeanTesterWorker.load(this.clazz, x, this.loadData, new String[0]);
            JavaBeanTesterWorker.load(this.extension, ext, this.loadData, new String[0]);
            Assertions.assertNotEquals(y, x, (String)String.format(".equals() should not be consistent for one empty and one loaded object of type %s", this.clazz.getName()));
            Assertions.assertNotEquals(y, ext, (String)String.format(".equals() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
            JavaBeanTesterWorker.load(this.clazz, y, this.loadData, new String[0]);
            if (this.loadData == LoadData.ON) {
                Assertions.assertEquals(x, y, (String)String.format(".equals() should be equal for two instances of type %s with loaded data", this.clazz.getName()));
                Assertions.assertEquals((int)x.hashCode(), (int)y.hashCode(), (String)String.format(".hashCode() should be equal for two instances of type %s with loaded data", this.clazz.getName()));
            } else {
                Assertions.assertNotEquals(x, y);
                Assertions.assertNotEquals((int)x.hashCode(), (int)y.hashCode());
            }
            Assertions.assertNotEquals(ext, y, (String)String.format(".equals() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
            Assertions.assertNotEquals((int)ext.hashCode(), (int)y.hashCode(), (String)String.format(".hashCode() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
            Assertions.assertNotEquals((Object)ext.toString(), (Object)y.toString(), (String)String.format(".toString() should not be equal for extension of type %s and empty object of type %s", this.extension.getName(), this.clazz.getName()));
        }
        try {
            BeanCopier clazzBeanCopier = BeanCopier.create(this.clazz, this.clazz, (boolean)true);
            e = new ClassInstance<T>().newInstance(this.clazz);
            clazzBeanCopier.copy(x, e, null);
            Assertions.assertEquals(e, x);
        }
        catch (Exception e3) {
            LOGGER.trace("Do nothing class is not mutable", (Throwable)e3);
        }
        try {
            BeanCopier extensionBeanCopier = BeanCopier.create(this.extension, this.extension, (boolean)true);
            e = new ClassInstance<E>().newInstance(this.extension);
            extensionBeanCopier.copy(ext, e, null);
            Assertions.assertEquals(e, ext);
        }
        catch (Exception e4) {
            LOGGER.trace("Do nothing class is not mutable", (Throwable)e4);
        }
    }

    void equalsTests(T instance, T expected) {
        PropertyDescriptor[] props;
        if (expected.hashCode() == instance.hashCode()) {
            Assertions.assertEquals((int)expected.hashCode(), (int)instance.hashCode());
        } else {
            Assertions.assertNotEquals((int)expected.hashCode(), (int)instance.hashCode());
        }
        ValueBuilder valueBuilder = new ValueBuilder();
        valueBuilder.setLoadData(this.loadData);
        for (PropertyDescriptor prop : props = this.getProps(instance.getClass())) {
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (getter == null && setter != null) {
                String isBooleanWrapper = "is" + setter.getName().substring(3);
                try {
                    getter = this.clazz.getMethod(isBooleanWrapper, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length != 1 || params[0] != returnType) continue;
            try {
                Object original = getter.invoke(instance, new Object[0]);
                Object value = valueBuilder.buildValue(returnType, LoadType.ALTERNATE_DATA);
                setter.invoke(instance, value);
                if (instance.equals(expected)) {
                    Assertions.assertEquals(expected, instance);
                } else {
                    Assertions.assertNotEquals(expected, instance);
                }
                value = valueBuilder.buildValue(returnType, LoadType.NULL_DATA);
                setter.invoke(instance, value);
                if (instance.equals(expected)) {
                    Assertions.assertEquals(expected, instance);
                } else {
                    Assertions.assertNotEquals(expected, instance);
                }
                setter.invoke(instance, original);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                Assertions.fail((String)String.format("An exception was thrown while testing the property (equals) '%s': '%s'", prop.getName(), e.toString()));
            }
        }
    }

    private boolean classHasSetters(Class<T> clazz) {
        return Arrays.stream(this.getProps(clazz)).anyMatch(propertyDescriptor -> propertyDescriptor.getWriteMethod() != null);
    }

    private PropertyDescriptor[] getProps(Class<?> clazz) {
        try {
            ArrayList<PropertyDescriptor> usedProps = new ArrayList<PropertyDescriptor>(Introspector.getBeanInfo(clazz).getPropertyDescriptors().length);
            List<PropertyDescriptor> props = Arrays.asList(Introspector.getBeanInfo(clazz).getPropertyDescriptors());
            block2: for (PropertyDescriptor prop : props) {
                for (String skipThis : this.skipThese) {
                    if (!skipThis.equals(prop.getName())) continue;
                    continue block2;
                }
                usedProps.add(prop);
            }
            return usedProps.toArray(new PropertyDescriptor[usedProps.size()]);
        }
        catch (IntrospectionException e) {
            Assertions.fail((String)String.format("An exception was thrown while testing class '%s': '%s'", this.clazz.getName(), e.toString()));
            return new PropertyDescriptor[0];
        }
    }

    public CheckClear getCheckClear() {
        return this.checkClear;
    }

    public CheckConstructor getCheckConstructor() {
        return this.checkConstructor;
    }

    public CheckEquals getCheckEquals() {
        return this.checkEquals;
    }

    public CheckSerialize getCheckSerializable() {
        return this.checkSerializable;
    }

    public LoadData getLoadData() {
        return this.loadData;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public Class<E> getExtension() {
        return this.extension;
    }

    public SkipStrictSerialize getSkipStrictSerializable() {
        return this.skipStrictSerializable;
    }

    public Set<String> getSkipThese() {
        return this.skipThese;
    }

    public void setCheckClear(CheckClear checkClear) {
        this.checkClear = checkClear;
    }

    public void setCheckConstructor(CheckConstructor checkConstructor) {
        this.checkConstructor = checkConstructor;
    }

    public void setCheckEquals(CheckEquals checkEquals) {
        this.checkEquals = checkEquals;
    }

    public void setCheckSerializable(CheckSerialize checkSerializable) {
        this.checkSerializable = checkSerializable;
    }

    public void setLoadData(LoadData loadData) {
        this.loadData = loadData;
    }

    public void setExtension(Class<E> extension) {
        this.extension = extension;
    }

    public void setSkipStrictSerializable(SkipStrictSerialize skipStrictSerializable) {
        this.skipStrictSerializable = skipStrictSerializable;
    }

    public void setSkipThese(Set<String> skipThese) {
        this.skipThese = skipThese;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaBeanTesterWorker)) {
            return false;
        }
        JavaBeanTesterWorker other = (JavaBeanTesterWorker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CheckClear this$checkClear = this.getCheckClear();
        CheckClear other$checkClear = other.getCheckClear();
        if (this$checkClear == null ? other$checkClear != null : !((Object)((Object)this$checkClear)).equals((Object)other$checkClear)) {
            return false;
        }
        CheckConstructor this$checkConstructor = this.getCheckConstructor();
        CheckConstructor other$checkConstructor = other.getCheckConstructor();
        if (this$checkConstructor == null ? other$checkConstructor != null : !((Object)((Object)this$checkConstructor)).equals((Object)other$checkConstructor)) {
            return false;
        }
        CheckEquals this$checkEquals = this.getCheckEquals();
        CheckEquals other$checkEquals = other.getCheckEquals();
        if (this$checkEquals == null ? other$checkEquals != null : !((Object)((Object)this$checkEquals)).equals((Object)other$checkEquals)) {
            return false;
        }
        CheckSerialize this$checkSerializable = this.getCheckSerializable();
        CheckSerialize other$checkSerializable = other.getCheckSerializable();
        if (this$checkSerializable == null ? other$checkSerializable != null : !((Object)((Object)this$checkSerializable)).equals((Object)other$checkSerializable)) {
            return false;
        }
        LoadData this$loadData = this.getLoadData();
        LoadData other$loadData = other.getLoadData();
        if (this$loadData == null ? other$loadData != null : !((Object)((Object)this$loadData)).equals((Object)other$loadData)) {
            return false;
        }
        Class<T> this$clazz = this.getClazz();
        Class<T> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Class<E> this$extension = this.getExtension();
        Class<E> other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
            return false;
        }
        SkipStrictSerialize this$skipStrictSerializable = this.getSkipStrictSerializable();
        SkipStrictSerialize other$skipStrictSerializable = other.getSkipStrictSerializable();
        if (this$skipStrictSerializable == null ? other$skipStrictSerializable != null : !((Object)((Object)this$skipStrictSerializable)).equals((Object)other$skipStrictSerializable)) {
            return false;
        }
        Set<String> this$skipThese = this.getSkipThese();
        Set<String> other$skipThese = other.getSkipThese();
        return !(this$skipThese == null ? other$skipThese != null : !((Object)this$skipThese).equals(other$skipThese));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JavaBeanTesterWorker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CheckClear $checkClear = this.getCheckClear();
        result = result * 59 + ($checkClear == null ? 43 : ((Object)((Object)$checkClear)).hashCode());
        CheckConstructor $checkConstructor = this.getCheckConstructor();
        result = result * 59 + ($checkConstructor == null ? 43 : ((Object)((Object)$checkConstructor)).hashCode());
        CheckEquals $checkEquals = this.getCheckEquals();
        result = result * 59 + ($checkEquals == null ? 43 : ((Object)((Object)$checkEquals)).hashCode());
        CheckSerialize $checkSerializable = this.getCheckSerializable();
        result = result * 59 + ($checkSerializable == null ? 43 : ((Object)((Object)$checkSerializable)).hashCode());
        LoadData $loadData = this.getLoadData();
        result = result * 59 + ($loadData == null ? 43 : ((Object)((Object)$loadData)).hashCode());
        Class<T> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Class<E> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
        SkipStrictSerialize $skipStrictSerializable = this.getSkipStrictSerializable();
        result = result * 59 + ($skipStrictSerializable == null ? 43 : ((Object)((Object)$skipStrictSerializable)).hashCode());
        Set<String> $skipThese = this.getSkipThese();
        result = result * 59 + ($skipThese == null ? 43 : ((Object)$skipThese).hashCode());
        return result;
    }

    public String toString() {
        return "JavaBeanTesterWorker(checkClear=" + (Object)((Object)this.getCheckClear()) + ", checkConstructor=" + (Object)((Object)this.getCheckConstructor()) + ", checkEquals=" + (Object)((Object)this.getCheckEquals()) + ", checkSerializable=" + (Object)((Object)this.getCheckSerializable()) + ", loadData=" + (Object)((Object)this.getLoadData()) + ", clazz=" + this.getClazz() + ", extension=" + this.getExtension() + ", skipStrictSerializable=" + (Object)((Object)this.getSkipStrictSerializable()) + ", skipThese=" + this.getSkipThese() + ")";
    }
}

