/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDirectoryGoal
extends AbstractMojo {
    @Parameter(defaultValue="dirProperty", required=true)
    protected String property;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject currentProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="false")
    protected boolean quiet;
    @Parameter(defaultValue="false")
    protected boolean systemProperty;
    private final Object lockObj = new Object();
    @Parameter(defaultValue="false", property="directory.skip")
    private boolean skip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        String existingValue;
        File execRoot;
        if (this.skip) {
            this.getLog().info((CharSequence)"Directory Plugin is skipped");
            return;
        }
        Object object = this.lockObj;
        synchronized (object) {
            String key = this.getContextKey();
            execRoot = (File)this.getPluginContext().get(key);
            if (execRoot == null) {
                execRoot = this.findDirectory();
                this.getPluginContext().put(key, execRoot);
            }
        }
        if (!this.quiet) {
            this.getLog().info((CharSequence)(this.getLogLabel() + " set to: " + String.valueOf(execRoot)));
        }
        this.currentProject.getProperties().setProperty(this.property, execRoot.getAbsolutePath());
        if (this.systemProperty && (existingValue = System.getProperty(this.property)) == null) {
            System.setProperty(this.property, execRoot.getAbsolutePath());
        }
        if (this.getLog().isDebugEnabled()) {
            try (StringWriter str = new StringWriter();
                 PrintWriter print = new PrintWriter(str);){
                this.currentProject.getProperties().list(print);
                this.getLog().debug((CharSequence)("After setting property '" + this.property + "', project properties are:\n\n" + String.valueOf(str)));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties", (Exception)e);
            }
        }
    }

    protected abstract String getLogLabel();

    protected abstract File findDirectory() throws MojoExecutionException;

    protected abstract String getContextKey();
}

