/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.util.ArrayDeque;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.plugins.execroot.AbstractDirectoryGoal;
import org.commonjava.maven.plugins.execroot.ProjectRef;

@Mojo(name="directory-of", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class DirectoryOfGoal
extends AbstractDirectoryGoal {
    protected static final String DIR_OF_CONTEXT_KEY = "directories.directoryOf-";
    @Parameter
    private ProjectRef project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> projects;

    @Override
    protected File findDirectory() throws MojoExecutionException {
        File dir = null;
        ArrayDeque<MavenProject> toCheck = new ArrayDeque<MavenProject>(this.projects);
        while (!toCheck.isEmpty()) {
            MavenProject mavenProject = (MavenProject)toCheck.pop();
            if (this.project.matches(mavenProject)) {
                dir = mavenProject.getBasedir();
                break;
            }
            if (mavenProject.getParent() == null) continue;
            toCheck.add(mavenProject.getParent());
        }
        if (dir == null) {
            throw new MojoExecutionException("Cannot find directory for project: " + String.valueOf(this.project));
        }
        return dir;
    }

    @Override
    protected String getContextKey() {
        return DIR_OF_CONTEXT_KEY + String.valueOf(this.project);
    }

    @Override
    protected String getLogLabel() {
        return "Directory of " + String.valueOf(this.project);
    }
}

