/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.plugins.execroot;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.plugins.execroot.AbstractDirectoryGoal;

@Mojo(name="highest-basedir", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class HighestBasedirGoal
extends AbstractDirectoryGoal {
    protected static final String HIGHEST_DIR_CONTEXT_KEY = "directories.highestDir";
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> projects;

    @Override
    protected File findDirectory() throws MojoExecutionException {
        ArrayDeque<MavenProject> toCheck = new ArrayDeque<MavenProject>(this.projects);
        String localRepoBaseDir = this.session.getRepositorySession().getLocalRepository().getBasedir().getAbsolutePath();
        ArrayList<File> files = new ArrayList<File>();
        while (!toCheck.isEmpty()) {
            MavenProject mavenProject = (MavenProject)toCheck.pop();
            if (mavenProject.getBasedir() == null || mavenProject.getBasedir().toString().startsWith(localRepoBaseDir)) continue;
            File file = new File(Paths.get(mavenProject.getBasedir().toURI()).normalize().toString());
            if (!files.contains(file)) {
                files.add(0, file);
            }
            if (mavenProject.getParent() == null) continue;
            toCheck.add(mavenProject.getParent());
        }
        if (files.isEmpty()) {
            throw new MojoExecutionException("No project base directories found! Are you sure you're executing this on a valid Maven project?");
        }
        Collections.sort(files, new PathComparator());
        File dir = (File)files.get(0);
        if (files.size() > 1) {
            File next = (File)files.get(1);
            String dirPath = dir.getAbsolutePath();
            String nextPath = next.getAbsolutePath();
            if (System.getProperty("os.name").startsWith("Windows")) {
                dirPath = dirPath.toLowerCase(Locale.ENGLISH);
                nextPath = nextPath.toLowerCase(Locale.ENGLISH);
            }
            if (!nextPath.startsWith(dirPath)) {
                this.getLog().error((CharSequence)("Candidate 1: " + dirPath));
                this.getLog().error((CharSequence)("Candidate 2: " + nextPath));
                throw new MojoExecutionException("Cannot find a single highest directory for this project set. First two candidates directories don't share a common root. Candidate 1: " + dirPath + " Candidate 2: " + nextPath);
            }
        }
        return dir;
    }

    @Override
    protected String getContextKey() {
        return HIGHEST_DIR_CONTEXT_KEY;
    }

    @Override
    protected String getLogLabel() {
        return "Highest basedir";
    }

    public static final class PathComparator
    implements Comparator<File> {
        @Override
        public int compare(File first, File second) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                return first.getAbsolutePath().compareToIgnoreCase(second.getAbsolutePath());
            }
            return first.getAbsolutePath().compareTo(second.getAbsolutePath());
        }
    }
}

